package tocraft.remorphed.mixin;

import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tocraft.remorphed.Remorphed;
import tocraft.remorphed.impl.RemorphedPlayerDataProvider;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.PlayerShapeChanger;
import tocraft.walkers.api.variant.ShapeType;

@Mixin(class_1309.class)
public abstract class LivingEntityMixin extends class_1297 {

    private LivingEntityMixin(class_1299<? extends class_1309> type, class_1937 world) {
        super(type, world);
    }

    @Inject(method = "die", at = @At("HEAD"))
    public void onDeath(class_1282 damageSource, CallbackInfo ci) {
        if (!((Object) this instanceof class_1657) && damageSource.method_5529() instanceof class_3222 killer) {
            ShapeType<?> type = ShapeType.from((class_1309) (Object) this);
            if (type != null) {
                ((RemorphedPlayerDataProvider) killer).remorphed$addKill(type);

                if (Remorphed.CONFIG.autoTransform && ((RemorphedPlayerDataProvider) killer).remorphed$getKills(type) >= Remorphed.getKillToUnlock(type.getEntityType())) {
                    PlayerShapeChanger.change2ndShape(killer, type);
                    PlayerShape.updateShapes(killer, type.create(killer.field_6002));
                }
            }
        }
    }
}
