package tocraft.remorphed.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.tree.LiteralCommandNode;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2170.class_5364;
import net.minecraft.class_2179;
import net.minecraft.class_2186;
import net.minecraft.class_2321;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import net.minecraft.class_7733;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;
import tocraft.remorphed.Remorphed;
import tocraft.remorphed.impl.RemorphedPlayerDataProvider;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerShapeChanger;
import tocraft.walkers.api.variant.ShapeType;

public class RemorphedCommand implements CommandRegistrationEvent {
    private static int hasShape(class_2168 source, class_3222 player, class_2960 id, @Nullable class_2487 nbt) {
        ShapeType<class_1309> type = getType(source.method_9225(), id, nbt);
        class_2561 name = class_2561.method_43471(type.getEntityType().method_5882());

        if (((RemorphedPlayerDataProvider) player).remorphed$getUnlockedShapes().containsKey(type)) {
            if (Walkers.CONFIG.logCommands) {
                source.method_45068(class_2561.method_43469(Remorphed.MODID + ".hasShape_success",
                        player.method_5476(), name));
            }

            return 1;
        } else if (Walkers.CONFIG.logCommands) {
            source.method_45068(class_2561.method_43469(Remorphed.MODID + ".hasShape_fail", player.method_5476(), name));
        }

        return 0;
    }

    private static void removeShape(class_2168 source, class_3222 player, class_2960 id, @Nullable class_2487 nbt) {
        ShapeType<class_1309> type = getType(source.method_9225(), id, nbt);
        class_2561 name = class_2561.method_43471(type.getEntityType().method_5882());

        ((RemorphedPlayerDataProvider) player).remorphed$getUnlockedShapes().remove(type);

        if (Walkers.CONFIG.logCommands) {
            source.method_45068(class_2561.method_43469(Remorphed.MODID + ".removeShape", name, player.method_5476()));
        }
    }

    private static void addShape(class_2168 source, class_3222 player, class_2960 id, @Nullable class_2487 nbt) {
        ShapeType<class_1309> type = getType(source.method_9225(), id, nbt);
        class_2561 name = class_2561.method_43471(type.getEntityType().method_5882());

        ((RemorphedPlayerDataProvider) player).remorphed$getUnlockedShapes().put(type, Remorphed.getKillToUnlock(type.getEntityType()));

        if (Walkers.CONFIG.logCommands) {
            source.method_45068(class_2561.method_43469(Remorphed.MODID + ".addShape", player.method_5476(), name));
        }
    }

    private static void clearShapes(class_2168 source, class_3222 player) {
        ((RemorphedPlayerDataProvider) player).remorphed$getUnlockedShapes().clear();

        if (Walkers.CONFIG.logCommands) {
            source.method_45068(class_2561.method_43469(Remorphed.MODID + ".clearShapes", player.method_5476()));
            PlayerShapeChanger.change2ndShape(player, null);
        }
    }

    @SuppressWarnings("unchecked")
    private static ShapeType<class_1309> getType(class_3218 serverLevel, class_2960 id, @Nullable class_2487 nbt) {
        ShapeType<class_1309> type = ShapeType.from((class_1299<class_1309>) class_7923.field_41177.method_10223(id));

        if (nbt != null) {
            class_2487 copy = nbt.method_10553();
            copy.method_10582("id", id.toString());
            class_1297 loaded = class_1299.method_17842(copy, serverLevel, it -> it);
            if (loaded instanceof class_1309 living) {
                type = new ShapeType<>(living);
            }
        }

        return type;
    }

    @Override
    public void register(CommandDispatcher<class_2168> dispatcher, class_7157 registry, class_5364 selection) {

        LiteralCommandNode<class_2168> rootNode = class_2170.method_9247(Remorphed.MODID)
                .requires(source -> source.method_9259(2)).build();

        /*
         * Used to remove a unlocked shape of the specified Player.
         */
        LiteralCommandNode<class_2168> removeShape = class_2170.method_9247("removeShape")
                .then(class_2170.method_9244("player", class_2186.method_9308())
                        .then(class_2170.method_9244("shape", class_7733.method_45603(registry, class_7924.field_41266))
                                .suggests(class_2321.field_10935).executes(context -> {
                                    removeShape(context.getSource(), class_2186.method_9315(context, "player"),
                                            class_1299.method_5890(class_7733
                                                    .method_45610(context, "shape").comp_349()),
                                            null);
                                    return 1;
                                }).then(class_2170.method_9244("nbt", class_2179.method_9284())
                                        .executes(context -> {
                                            class_2487 nbt = class_2179.method_9285(context, "nbt");

                                            removeShape(context.getSource(),
                                                    class_2186.method_9315(context, "player"),
                                                    class_1299.method_5890(class_7733
                                                            .method_45610(context, "shape").comp_349()),
                                                    nbt);

                                            return 1;
                                        }))))
                .build();

        /*
         * Used to add a shape to the specified Player.
         */
        LiteralCommandNode<class_2168> addShape = class_2170.method_9247("addShape")
                .then(class_2170.method_9244("player", class_2186.method_9308())
                        .then(class_2170.method_9244("shape", class_7733.method_45603(registry, class_7924.field_41266))
                                .suggests(class_2321.field_10935).executes(context -> {
                                    addShape(context.getSource(), class_2186.method_9315(context, "player"),
                                            class_1299.method_5890(class_7733
                                                    .method_45610(context, "shape").comp_349()),
                                            null);
                                    return 1;
                                }).then(class_2170.method_9244("nbt", class_2179.method_9284())
                                        .executes(context -> {
                                            class_2487 nbt = class_2179.method_9285(context, "nbt");

                                            addShape(context.getSource(),
                                                    class_2186.method_9315(context, "player"),
                                                    class_1299.method_5890(class_7733
                                                            .method_45610(context, "shape").comp_349()),
                                                    nbt);

                                            return 1;
                                        }))))
                .build();

        /*
         * Used to remove all unlocked shapes of the specified Player.
         */
        LiteralCommandNode<class_2168> clearShapes = class_2170.method_9247("clearShapes")
                .then(class_2170.method_9244("player", class_2186.method_9308()).executes(context -> {
                    clearShapes(context.getSource(), class_2186.method_9315(context, "player"));
                    return 1;
                })).build();

        /*
         * Used to check if a player has unlocked a specific shape
         */
        LiteralCommandNode<class_2168> hasShape = class_2170.method_9247("hasShape")
                .then(class_2170.method_9244("player", class_2186.method_9308())
                        .then(class_2170.method_9244("shape", class_7733.method_45603(registry, class_7924.field_41266))
                                .suggests(class_2321.field_10935).executes(context -> hasShape(context.getSource(), class_2186.method_9315(context, "player"),
                                        class_1299.method_5890(class_7733
                                                .method_45610(context, "shape").comp_349()),
                                        null)).then(class_2170.method_9244("nbt", class_2179.method_9284())
                                        .executes(context -> {
                                            class_2487 nbt = class_2179.method_9285(context, "nbt");

                                            return hasShape(context.getSource(),
                                                    class_2186.method_9315(context, "player"),
                                                    class_1299.method_5890(class_7733
                                                            .method_45610(context, "shape").comp_349()),
                                                    nbt);
                                        }))))
                .build();

        rootNode.addChild(removeShape);
        rootNode.addChild(addShape);
        rootNode.addChild(clearShapes);
        rootNode.addChild(hasShape);

        dispatcher.getRoot().addChild(rootNode);

    }
}
