package tocraft.remorphed;

import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import io.netty.buffer.Unpooled;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tocraft.craftedcore.config.ConfigLoader;
import tocraft.craftedcore.platform.VersionChecker;
import tocraft.remorphed.command.RemorphedCommand;
import tocraft.remorphed.config.RemorphedConfig;
import tocraft.remorphed.events.ShapeSwapCallback;
import tocraft.remorphed.events.UnlockShapeCallback;
import tocraft.remorphed.impl.RemorphedPlayerDataProvider;
import tocraft.remorphed.network.NetworkHandler;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.event.ShapeEvents;
import tocraft.walkers.api.variant.ShapeType;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;

public class Remorphed {

    public static final Logger LOGGER = LoggerFactory.getLogger(Remorphed.class);
    public static final String MODID = "remorphed";
    public static final RemorphedConfig CONFIG = ConfigLoader.read(MODID, RemorphedConfig.class);
    private static final String MAVEN_URL = "https://maven.tocraft.dev/public/dev/tocraft/remorphed/maven-metadata.xml";
    public static boolean displayVariantsInMenu = true;

    public void initialize() {
        // add DarkShadow_2k to devs (for creating the special shape icon and concepts)
        Walkers.devs.add(UUID.fromString("74b6d9b3-c8c1-40db-ab82-ccc290d1aa03"));

        try {
            VersionChecker.registerMavenChecker(MODID, new URL(MAVEN_URL), class_2561.method_43470("Remorphed"));
        } catch (MalformedURLException ignored) {
        }

        if (Platform.getEnvironment() == Env.CLIENT) new RemorphedClient().initialize();

        NetworkHandler.registerPacketReceiver();

        ShapeEvents.UNLOCK_SHAPE.register(new UnlockShapeCallback());
        ShapeEvents.SWAP_SHAPE.register(new ShapeSwapCallback());
        CommandRegistrationEvent.EVENT.register(new RemorphedCommand());

        // allow unlocking friendly mobs via the "normal" method
        Walkers.CONFIG.unlockOverridesCurrentShape = Remorphed.CONFIG.unlockFriendlyNormal;
        Walkers.CONFIG.save();

        // Sync favorites
        PlayerEvent.PLAYER_JOIN.register(NetworkHandler::sendFavoriteSync);
    }

    public static boolean canUseShape(class_1657 player, ShapeType<?> type) {
        return player.method_7337() || !Remorphed.CONFIG.lockTransform && (type == null || Remorphed.getKillToUnlock(type.getEntityType()) <= 0 || ((RemorphedPlayerDataProvider) player).remorphed$getKills(type) >= Remorphed.getKillToUnlock(type.getEntityType()));
    }

    public static boolean canUseAnyShape(class_1657 player) {
        boolean canUseShapes = player.method_7337() || Remorphed.CONFIG.killToUnlock <= 0;

        for (ShapeType<? extends class_1309> shape : ((RemorphedPlayerDataProvider) player).remorphed$getUnlockedShapes().keySet()) {
            canUseShapes = canUseShapes ? canUseShapes : canUseShape(player, shape);
        }

        return canUseShapes;
    }

    public static int getKillToUnlock(class_1299<?> entityType) {
        String id = class_7923.field_41177.method_10221(entityType).toString();
        if (Remorphed.CONFIG.killToUnlockByType.containsKey(id)) return Remorphed.CONFIG.killToUnlockByType.get(id);
        else return Remorphed.CONFIG.killToUnlock;
    }

    public static void sync(class_3222 player) {
        sync(player, player);
    }

    public static void sync(class_3222 changed, class_3222 packetTarget) {
        class_2540 packet = new class_2540(Unpooled.buffer());
        class_2487 compoundTag = new class_2487();

        // serialize current shape data to tag if it exists
        Map<ShapeType<?>, Integer> unlockedShapes = ((RemorphedPlayerDataProvider) changed).remorphed$getUnlockedShapes();

        class_2499 list = new class_2499();

        unlockedShapes.forEach((shape, killAmount) -> {
            if (killAmount > 0 && shape != null) {
                class_2487 compound = new class_2487();
                compound.method_10582("id", class_7923.field_41177.method_10221(shape.getEntityType()).toString());
                compound.method_10569("variant", shape.getVariantData());
                compound.method_10569("killAmount", killAmount);
                list.add(compound);
            }
        });

        if (!unlockedShapes.isEmpty()) compoundTag.method_10566("UnlockedShapes", list);

        packet.method_10797(changed.method_5667());
        packet.method_10794(compoundTag);
        NetworkManager.sendToPlayer(packetTarget, NetworkHandler.UNLOCKED_SYNC, packet);
    }

    public static class_2960 id(String name) {
        return new class_2960(MODID, name);
    }
}
