/*
 * Decompiled with CFR 0.152.
 */
package tocraft.craftedcore.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Set;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.transformer.ClassInfo;

public class TraceUtils {
    public static void printMixinTrace(StackTraceElement[] stackTrace, StringBuilder crashReportBuilder) {
        if (stackTrace != null && stackTrace.length > 0) {
            crashReportBuilder.append("\nMixins in Stacktrace:");
            try {
                ArrayList<String> classNames = new ArrayList<String>();
                for (StackTraceElement el : stackTrace) {
                    if (classNames.contains(el.getClassName())) continue;
                    classNames.add(el.getClassName());
                }
                boolean found = false;
                for (String className : classNames) {
                    Set mixinInfoSet;
                    Object mixinInfoSetObject;
                    ClassInfo classInfo = ClassInfo.fromCache((String)className);
                    if (classInfo == null) continue;
                    try {
                        Method getMixins = ClassInfo.class.getDeclaredMethod("getMixins", new Class[0]);
                        getMixins.setAccessible(true);
                        mixinInfoSetObject = getMixins.invoke((Object)classInfo, new Object[0]);
                    }
                    catch (Exception e) {
                        Field mixinsField = ClassInfo.class.getDeclaredField("mixins");
                        mixinsField.setAccessible(true);
                        mixinInfoSetObject = mixinsField.get(classInfo);
                    }
                    if ((mixinInfoSet = (Set)mixinInfoSetObject).isEmpty()) continue;
                    crashReportBuilder.append("\n\t");
                    crashReportBuilder.append(className);
                    crashReportBuilder.append(":");
                    for (IMixinInfo info : mixinInfoSet) {
                        crashReportBuilder.append("\n\t\t");
                        crashReportBuilder.append(info.getClassName());
                        crashReportBuilder.append(" (");
                        crashReportBuilder.append(info.getConfig().getName());
                        crashReportBuilder.append(")");
                    }
                    found = true;
                }
                if (!found) {
                    crashReportBuilder.append(" None found");
                }
            }
            catch (Exception e) {
                crashReportBuilder.append(" Failed to find Mixin metadata: ").append(e);
            }
        }
    }
}

