/*
 * Decompiled with CFR 0.152.
 */
package tocraft.craftedcore.network;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import tocraft.craftedcore.network.fabric.ModernNetworkingImpl;

public class ModernNetworking {
    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerReceiver(Side side, ResourceLocation id, Receiver receiver) {
        void var2_2;
        void var1_1;
        ModernNetworkingImpl.registerReceiver((Side)side, (ResourceLocation)var1_1, (Receiver)var2_2);
    }

    public static void sendToPlayer(ServerPlayer player, ResourceLocation packetId, CompoundTag data) {
        player.f_8906_.m_141995_(ModernNetworking.toPacket(Side.S2C, packetId, data));
    }

    public static void sendToPlayers(Iterable<ServerPlayer> players, ResourceLocation packetId, CompoundTag data) {
        for (ServerPlayer player : players) {
            ModernNetworking.sendToPlayer(player, packetId, data);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void sendToServer(ResourceLocation packetId, CompoundTag data) {
        ClientPacketListener connection = Minecraft.m_91087_().m_91403_();
        if (connection != null) {
            connection.m_295327_(ModernNetworking.toPacket(Side.C2S, packetId, data));
        }
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ApiStatus.Internal
    @ExpectPlatform.Transformed
    public static Packet<?> toPacket(Side side, ResourceLocation id, CompoundTag data) {
        void var2_2;
        void var1_1;
        return ModernNetworkingImpl.toPacket((Side)side, (ResourceLocation)var1_1, (CompoundTag)var2_2);
    }

    public static enum Side {
        S2C,
        C2S;

    }

    @ApiStatus.Internal
    public static final class PacketPayload
    extends Record
    implements CustomPacketPayload {
        private final ResourceLocation id;
        private final CompoundTag nbt;

        public PacketPayload(FriendlyByteBuf buf) {
            this(buf.m_130281_(), buf.m_130260_());
        }

        public PacketPayload(ResourceLocation id, CompoundTag nbt) {
            this.id = id;
            this.nbt = nbt;
        }

        public void m_293110_(FriendlyByteBuf buf) {
            buf.m_130085_(this.id);
            buf.m_130079_((Tag)this.nbt);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{PacketPayload.class, "id;nbt", "id", "nbt"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{PacketPayload.class, "id;nbt", "id", "nbt"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{PacketPayload.class, "id;nbt", "id", "nbt"}, this, o);
        }

        public ResourceLocation m_292644_() {
            return this.id;
        }

        public CompoundTag nbt() {
            return this.nbt;
        }
    }

    public static enum Env {
        CLIENT,
        SERVER;

    }

    public static interface Context {
        public Player getPlayer();

        public Env getEnv();

        public void queue(Runnable var1);
    }

    @FunctionalInterface
    public static interface Receiver {
        public void receive(Context var1, CompoundTag var2);
    }
}

