/*
 * Decompiled with CFR 0.152.
 */
package tocraft.craftedcore.data;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import tocraft.craftedcore.CraftedCore;
import tocraft.craftedcore.data.PlayerDataProvider;
import tocraft.craftedcore.network.ModernNetworking;
import tocraft.craftedcore.network.client.ClientNetworking;
import tocraft.craftedcore.registration.PlayerDataRegistry;

public class PlayerDataSynchronizer {
    private static final String PLAYER_DATA_SYNC = "player_data_sync";
    public static final ResourceLocation PLAYER_DATA_SYNC_ID = CraftedCore.id("player_data_sync");

    public static void registerPacketHandler() {
        ModernNetworking.registerReceiver(ModernNetworking.Side.S2C, PLAYER_DATA_SYNC_ID, (context, tag) -> {
            ListTag list;
            if (tag != null && (list = (ListTag)tag.m_128423_(PLAYER_DATA_SYNC)) != null) {
                for (Tag entry : list) {
                    for (String key : ((CompoundTag)entry).m_128431_()) {
                        ClientNetworking.runOrQueue(context, player -> ((PlayerDataProvider)player).craftedcore$writeTag(key, ((CompoundTag)entry).m_128423_(key)));
                    }
                }
            }
        });
    }

    public static void sync(ServerPlayer player) {
        CompoundTag tag = new CompoundTag();
        ListTag list = new ListTag();
        PlayerDataProvider playerData = (PlayerDataProvider)player;
        for (String key : ((PlayerDataProvider)player).craftedcore$keySet()) {
            if (!PlayerDataRegistry.shouldSyncKey(key)) {
                return;
            }
            CompoundTag entry = new CompoundTag();
            entry.m_128365_(key, playerData.craftedcore$readTag(key));
            list.add((Object)entry);
        }
        tag.m_128365_(PLAYER_DATA_SYNC, (Tag)list);
        ModernNetworking.sendToPlayer(player, PLAYER_DATA_SYNC_ID, tag);
    }
}

