/*
 * Decompiled with CFR 0.152.
 */
package tocraft.craftedcore.registration;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import tocraft.craftedcore.data.PlayerDataProvider;

public class PlayerDataRegistry {
    private static final Map<String, TagData> CraftedTagKeys = new HashMap<String, TagData>();

    public static void registerKey(String key, boolean persistent) {
        PlayerDataRegistry.registerKey(key, persistent, true);
    }

    public static boolean isKeyRegistered(String key) {
        return CraftedTagKeys.containsKey(key);
    }

    public static void registerKey(String key, boolean persistent, boolean sync) {
        PlayerDataRegistry.registerKey(key, persistent, sync, sync);
    }

    public static void registerKey(String key, boolean persistent, boolean syncToSelf, boolean syncToOthers) {
        CraftedTagKeys.put(key, new TagData(persistent, syncToSelf, syncToOthers));
    }

    public static boolean isKeyPersistent(String key) {
        return CraftedTagKeys.containsKey(key) && CraftedTagKeys.get(key).persistent();
    }

    public static boolean shouldSyncKey(String key) {
        return PlayerDataRegistry.shouldSyncTagToSelf(key) && PlayerDataRegistry.shouldSyncTagToAll(key);
    }

    public static boolean shouldSyncTagToSelf(String key) {
        return CraftedTagKeys.containsKey(key) && CraftedTagKeys.get(key).syncToSelf();
    }

    public static boolean shouldSyncTagToAll(String key) {
        return CraftedTagKeys.containsKey(key) && CraftedTagKeys.get(key).syncToAll();
    }

    public static void writeTag(Player player, String key, @NotNull Tag value) throws NotRegisteredTagKeyException {
        PlayerDataProvider playerDataProvider = (PlayerDataProvider)player;
        if (!PlayerDataRegistry.isKeyRegistered(key)) {
            throw new NotRegisteredTagKeyException(key);
        }
        playerDataProvider.craftedcore$writeTag(key, value);
    }

    public static Tag readTag(Player player, String key) throws NotRegisteredTagKeyException {
        PlayerDataProvider playerDataProvider = (PlayerDataProvider)player;
        if (PlayerDataRegistry.isKeyRegistered(key)) {
            return playerDataProvider.craftedcore$readTag(key);
        }
        throw new NotRegisteredTagKeyException(key);
    }

    public static Set<String> keySet() {
        return CraftedTagKeys.keySet();
    }

    private record TagData(boolean persistent, boolean syncToSelf, boolean syncToAll) {
    }

    public static class NotRegisteredTagKeyException
    extends IllegalArgumentException {
        public NotRegisteredTagKeyException(String key) {
            super("Player Data Key " + key + " not found!");
        }
    }
}

