/*
 * Decompiled with CFR 0.152.
 */
package tocraft.craftedcore.event.common;

import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;
import tocraft.craftedcore.event.Event;
import tocraft.craftedcore.event.EventFactory;

public final class PlayerEvents {
    public static final Event<PlayerJoin> PLAYER_JOIN = EventFactory.createWithVoid(new PlayerJoin[0]);
    public static final Event<PlayerQuit> PLAYER_QUIT = EventFactory.createWithVoid(new PlayerQuit[0]);
    public static final Event<PlayerRespawn> PLAYER_RESPAWN = EventFactory.createWithVoid(new PlayerRespawn[0]);
    public static final Event<AwardAdvancement> AWARD_ADVANCEMENT = EventFactory.createWithVoid(new AwardAdvancement[0]);
    public static final Event<RevokeAdvancement> REVOKE_ADVANCEMENT = EventFactory.createWithVoid(new RevokeAdvancement[0]);
    public static final Event<AllowSleepTime> ALLOW_SLEEP_TIME = EventFactory.createWithInteractionResult(new AllowSleepTime[0]);
    public static final Event<SleepFinishedTime> SLEEP_FINISHED_TIME = EventFactory.createWithCallback(callbacks -> (level, newTime) -> {
        long newNewTime = 0L;
        for (SleepFinishedTime callback : callbacks) {
            long newTimeIn = callback.setTimeAddition(level, newTime);
            if (level.m_46468_() > newTime) continue;
            newNewTime = newTimeIn;
        }
        return newNewTime;
    });
    public static final Event<DestroySpeed> DESTROY_SPEED = EventFactory.createWithCallback(callbacks -> (player, newSpeed) -> {
        for (DestroySpeed callback : callbacks) {
            newSpeed = callback.setDestroySpeed(player, newSpeed);
        }
        return newSpeed;
    });

    @FunctionalInterface
    public static interface DestroySpeed {
        public float setDestroySpeed(Player var1, float var2);
    }

    @FunctionalInterface
    public static interface SleepFinishedTime {
        public long setTimeAddition(ServerLevel var1, long var2);
    }

    @FunctionalInterface
    public static interface PlayerJoin {
        public void join(ServerPlayer var1);
    }

    @FunctionalInterface
    public static interface PlayerQuit {
        public void quit(ServerPlayer var1);
    }

    @FunctionalInterface
    public static interface PlayerRespawn {
        public void clone(ServerPlayer var1, ServerPlayer var2);
    }

    @FunctionalInterface
    public static interface AwardAdvancement {
        public void award(ServerPlayer var1, AdvancementHolder var2, String var3);
    }

    @FunctionalInterface
    public static interface RevokeAdvancement {
        public void revoke(ServerPlayer var1, AdvancementHolder var2, String var3);
    }

    @FunctionalInterface
    public static interface AllowSleepTime {
        public InteractionResult allowSleepTime(Player var1, @Nullable BlockPos var2, boolean var3);
    }
}

