/*
 * Decompiled with CFR 0.152.
 */
package tocraft.craftedcore.event;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.function.Function;
import net.minecraft.world.InteractionResult;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import tocraft.craftedcore.event.Event;

public final class EventFactory {
    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <T> Event<T> createWithCallback(Function<List<T>, T> invoker) {
        return new Event<T>(invoker);
    }

    @SafeVarargs
    @NotNull
    public static <T> Event<T> createWithInteractionResult(T ... typeGetter) {
        return EventFactory.createWithInteractionResult(typeGetter.getClass().getComponentType());
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <T> Event<T> createWithInteractionResult(Class<T> clazz) {
        return new Event<Object>(listeners -> Proxy.newProxyInstance(EventFactory.class.getClassLoader(), new Class[]{clazz}, (proxy, method, args) -> {
            for (Object listener : listeners) {
                Object result = MethodHandles.lookup().unreflect(method).bindTo(listener).invokeWithArguments(args);
                if (result == InteractionResult.PASS) continue;
                return result;
            }
            return InteractionResult.PASS;
        }));
    }

    @SafeVarargs
    @NotNull
    public static <T> Event<T> createWithVoid(T ... typeGetter) {
        return EventFactory.createWithVoid(typeGetter.getClass().getComponentType());
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <T> Event<T> createWithVoid(Class<T> clazz) {
        return new Event<Object>(listeners -> Proxy.newProxyInstance(EventFactory.class.getClassLoader(), new Class[]{clazz}, (proxy, method, args) -> {
            for (Object listener : listeners) {
                MethodHandles.lookup().unreflect(method).bindTo(listener).invokeWithArguments(args);
            }
            return null;
        }));
    }
}

