/*
 * Decompiled with CFR 0.152.
 */
package tocraft.craftedcore.config;

import java.nio.file.Path;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import tocraft.craftedcore.CraftedCore;
import tocraft.craftedcore.config.ClothConfigApi;
import tocraft.craftedcore.config.ConfigLoader;
import tocraft.craftedcore.network.ModernNetworking;
import tocraft.craftedcore.platform.PlatformData;

public interface Config {
    @Nullable
    public String getName();

    @Nullable
    default public Path getPath() {
        return this.getName() != null ? ConfigLoader.getConfigPath(this.getName()) : null;
    }

    default public void save() {
        ConfigLoader.writeConfigFile(this);
    }

    default public void sendToPlayer(ServerPlayer target) {
        ModernNetworking.sendToPlayer(target, ConfigLoader.CONFIG_SYNC, ConfigLoader.getConfigSyncTag(this));
    }

    default public void sendToAllPlayers(ServerLevel serverLevel) {
        for (ServerPlayer target : serverLevel.m_6907_()) {
            this.sendToPlayer(target);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    default public Screen constructConfigScreen(Screen parent) {
        if (PlatformData.isModLoaded("cloth-config") || PlatformData.isModLoaded("cloth_config")) {
            return ClothConfigApi.constructConfigScreen(this, parent);
        }
        CraftedCore.LOGGER.warn("Cloth config not found!");
        return null;
    }
}

