package tocraft.craftedcore;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.tree.LiteralCommandNode;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import tocraft.craftedcore.event.common.CommandEvents;
import tocraft.craftedcore.network.ModernNetworking;
import tocraft.craftedcore.patched.CCommandSourceStack;
import tocraft.craftedcore.patched.TComponent;

public class CraftedCoreCommand {

    //#if MC>1182
    public static void initialize() {
        CommandEvents.REGISTRATION.register((dispatcher, ctx, selection) -> register(dispatcher));
    }
    //#else
    //$$ public static void initialize() {
    //$$     CommandEvents.REGISTRATION.register((dispatcher, ctx) -> register(dispatcher));
    //$$ }
    //#endif

    private static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralCommandNode<CommandSourceStack> craftedcore = Commands.m_82127_(CraftedCore.MODID)
                .then(Commands.m_82127_("clear").then(Commands.m_82127_("cache")
                        .executes(context -> {
                            CraftedCore.clearCache();
                            for (ServerLevel level : context.getSource().m_81377_().m_129785_()) {
                                ModernNetworking.sendToPlayers(level.m_6907_(), CraftedCore.CLEAR_CACHE_PACKET, new CompoundTag());
                            }
                            CCommandSourceStack.sendSuccess(context.getSource(), TComponent.translatable("craftedcore.command.clear_cache"), true);
                            return 1;
                        })))
                .build();
        dispatcher.getRoot().addChild(craftedcore);
    }
}
