package tocraft.craftedcore.data;

import net.minecraft.nbt.*;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import tocraft.craftedcore.CraftedCore;
import tocraft.craftedcore.network.ModernNetworking;
import tocraft.craftedcore.network.client.ClientNetworking;
import tocraft.craftedcore.patched.CEntity;
import tocraft.craftedcore.registration.PlayerDataRegistry;

import java.util.Objects;

public class PlayerDataSynchronizer {
    private static final String PLAYER_DATA_SYNC = "player_data_sync";
    public static final ResourceLocation PLAYER_DATA_SYNC_ID = CraftedCore.id(PLAYER_DATA_SYNC);

    public static void registerPacketHandler() {
        ModernNetworking.registerReceiver(ModernNetworking.Side.S2C, PLAYER_DATA_SYNC_ID, (context, tag) -> {
            if (tag != null) {
                ListTag list = (ListTag) tag.m_128423_(PLAYER_DATA_SYNC);
                if (list != null) {
                    for (Tag entry : list) {
                            for (String key : ((CompoundTag) entry).m_128431_()) {
                                if (Objects.equals(key, "DELETED")) {
                                    ClientNetworking.runOrQueue(context, player -> {
                                        PlayerDataProvider playerDataProvider;
                                        if (tag.m_128403_("uuid")) {
                                            playerDataProvider = (PlayerDataProvider) player.m_20193_().m_46003_(tag.m_128342_("uuid"));
                                        } else {
                                            playerDataProvider = (PlayerDataProvider) player;
                                        }
                                        if (playerDataProvider != null) {
                                            playerDataProvider.craftedcore$writeTag(Objects.requireNonNull(((CompoundTag) entry).m_128423_(key)).m_7916_(), null);
                                        }
                                    });
                                } else {
                                    ClientNetworking.runOrQueue(context, player -> {
                                        PlayerDataProvider playerDataProvider;
                                        if (tag.m_128403_("uuid")) {
                                            playerDataProvider = (PlayerDataProvider) player.m_20193_().m_46003_(tag.m_128342_("uuid"));
                                        } else {
                                            playerDataProvider = (PlayerDataProvider) player;
                                        }
                                        if (playerDataProvider != null) {
                                            playerDataProvider.craftedcore$writeTag(key, ((CompoundTag) entry).m_128423_(key));
                                        }
                                    });
                                }
                            }
                    }
                }
            }
        });
    }

    /**
     * Synchronize data from the server to the client
     */
    public static void sync(ServerPlayer player) {
        syncToSelf(player);
        syncToAll(player);
    }

    private static void syncToSelf(ServerPlayer player) {
        CompoundTag tag = new CompoundTag();
        ListTag list = new ListTag();

        PlayerDataProvider playerData = ((PlayerDataProvider) player);

        for (String key : ((PlayerDataProvider) player).craftedcore$keySet()) {
            // ignore key if it shouldn't be synchronized to the client
            if (!PlayerDataRegistry.shouldSyncTagToSelf(key)) {
                return;
            }

            CompoundTag entry = new CompoundTag();
            Tag value = playerData.craftedcore$readTag(key);
            if (value != null) {
                entry.m_128365_(key, value);
            } else {
                entry.m_128365_("DELETED", StringTag.m_129297_(key));
            }            list.add(entry);
        }
        tag.m_128365_(PLAYER_DATA_SYNC, list);

        ModernNetworking.sendToPlayer(player, PLAYER_DATA_SYNC_ID, tag);
    }

    private static void syncToAll(ServerPlayer player) {
        CompoundTag tag = new CompoundTag();
        ListTag list = new ListTag();

        tag.m_128362_("uuid", player.m_20148_());
        PlayerDataProvider playerData = ((PlayerDataProvider) player);

        for (String key : ((PlayerDataProvider) player).craftedcore$keySet()) {
            // ignore key if it shouldn't be synchronized to the client
            if (!PlayerDataRegistry.shouldSyncTagToAll(key)) {
                return;
            }

            CompoundTag entry = new CompoundTag();
            Tag value = playerData.craftedcore$readTag(key);
            if (value != null) {
                entry.m_128365_(key, value);
            } else {
                entry.m_128365_("DELETED", StringTag.m_129297_(key));
            }
            list.add(entry);
        }
        tag.m_128365_(PLAYER_DATA_SYNC, list);
        //noinspection resource
        ModernNetworking.sendToPlayers(((ServerLevel) CEntity.level(player)).m_6907_(), PLAYER_DATA_SYNC_ID, tag);
    }
}
