/*
 * Decompiled with CFR 0.152.
 */
package tocraft.craftedcore.platform.forge;

import java.lang.module.ModuleDescriptor;
import java.nio.file.Path;
import java.util.Objects;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import tocraft.craftedcore.config.ConfigLoader;
import tocraft.craftedcore.platform.PlatformData;

public final class PlatformDataImpl {
    public static boolean isModLoaded(String modid) {
        return ModList.get().isLoaded(modid);
    }

    @Nullable
    public static ModuleDescriptor.Version getModVersion(String modid) {
        return ModList.get().getModContainerById(modid).map(modContainer -> ModuleDescriptor.Version.parse(modContainer.getModInfo().getVersion().toString())).orElse(null);
    }

    public static boolean isDevEnv() {
        return !FMLLoader.isProduction();
    }

    public static Dist getEnv() {
        return FMLLoader.getDist();
    }

    public static Path getConfigPath() {
        return FMLPaths.CONFIGDIR.get();
    }

    public static PlatformData.ModLoader getModLoaderId() {
        return PlatformData.ModLoader.FORGE;
    }

    @OnlyIn(value=Dist.CLIENT)
    @ApiStatus.Internal
    public static void registerConfigScreen(String name) {
        if (ModList.get().getModContainerById("cloth_config").isPresent()) {
            ModList.get().getModContainerById(name).ifPresent(mod -> mod.registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((minecraft, parent) -> Objects.requireNonNull(ConfigLoader.getConfigByName(name)).constructConfigScreen((Screen)parent))));
        }
    }
}

