/*
 * Decompiled with CFR 0.152.
 */
package tocraft.craftedcore.platform;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.lang.module.ModuleDescriptor;
import java.nio.file.Path;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import tocraft.craftedcore.platform.forge.PlatformDataImpl;

public final class PlatformData {
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isModLoaded(String modid) {
        return PlatformDataImpl.isModLoaded(modid);
    }

    @ExpectPlatform
    @Nullable
    @ExpectPlatform.Transformed
    public static ModuleDescriptor.Version getModVersion(String modid) {
        return PlatformDataImpl.getModVersion(modid);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isDevEnv() {
        return PlatformDataImpl.isDevEnv();
    }

    @Contract(value=" -> !null", pure=true)
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Dist getEnv() {
        return PlatformDataImpl.getEnv();
    }

    @ExpectPlatform
    @Contract(value=" -> !null", pure=true)
    @ExpectPlatform.Transformed
    public static Path getConfigPath() {
        return PlatformDataImpl.getConfigPath();
    }

    @ExpectPlatform
    @Contract(value=" -> !null", pure=true)
    @ExpectPlatform.Transformed
    public static ModLoader getModLoaderId() {
        return PlatformDataImpl.getModLoaderId();
    }

    @OnlyIn(value=Dist.CLIENT)
    @ExpectPlatform
    @ApiStatus.Internal
    @ExpectPlatform.Transformed
    public static void registerConfigScreen(String name) {
        PlatformDataImpl.registerConfigScreen(name);
    }

    public static enum ModLoader {
        FABRIC,
        FORGE,
        NEOFORGE,
        OTHER;

    }
}

