/*
 * Decompiled with CFR 0.152.
 */
package tocraft.craftedcore.mixin;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tocraft.craftedcore.data.PlayerDataProvider;
import tocraft.craftedcore.event.common.EntityEvents;
import tocraft.craftedcore.registration.PlayerDataRegistry;

@Mixin(value={Player.class})
public abstract class PlayerMixin
implements PlayerDataProvider {
    @Unique
    private final Map<String, Tag> craftedcore$playerData = new HashMap<String, Tag>();

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="RETURN")})
    private void readNbt(CompoundTag tag, CallbackInfo info) {
        for (String k : PlayerDataRegistry.keySet()) {
            this.craftedcore$playerData.put(k, tag.m_128423_(k));
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="RETURN")})
    private void writeNbt(CompoundTag tag, CallbackInfo info) {
        this.craftedcore$playerData.forEach((k, v) -> {
            if (v != null && PlayerDataRegistry.isKeyRegistered(k)) {
                tag.m_128365_(k, v);
            }
        });
    }

    @Inject(method={"interactOn"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getItemInHand(Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/item/ItemStack;", ordinal=0)}, cancellable=true)
    private void onInteraction(Entity entity, InteractionHand interactionHand, CallbackInfoReturnable<InteractionResult> cir) {
        InteractionResult result = EntityEvents.INTERACT_WITH_PLAYER.invoke().interact((Player)this, entity, interactionHand);
        if (result != InteractionResult.PASS) {
            cir.setReturnValue((Object)result);
        }
    }

    @Override
    @Unique
    public Set<String> craftedcore$keySet() {
        return this.craftedcore$playerData.keySet();
    }

    @Override
    @Unique
    public void craftedcore$writeTag(String key, Tag tag) {
        this.craftedcore$playerData.put(key, tag);
    }

    @Override
    @Unique
    public Tag craftedcore$readTag(String key) {
        return this.craftedcore$playerData.get(key);
    }
}

