/*
 * Decompiled with CFR 0.152.
 */
package tocraft.craftedcore.forge.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import tocraft.craftedcore.event.client.ClientPlayerEvents;
import tocraft.craftedcore.event.client.ClientTickEvents;
import tocraft.craftedcore.event.client.RenderEvents;

@OnlyIn(value=Dist.CLIENT)
public class CraftedCoreForgeEventHandlerClient {
    @SubscribeEvent
    public void event(CustomizeGuiOverlayEvent event) {
        RenderEvents.HUD_RENDERING.invoke().render(event.getGuiGraphics(), event.getPartialTick());
    }

    @SubscribeEvent
    public void event(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ClientTickEvents.CLIENT_PRE.invoke().tick(Minecraft.m_91087_());
        } else if (event.phase == TickEvent.Phase.END) {
            ClientTickEvents.CLIENT_POST.invoke().tick(Minecraft.m_91087_());
        }
    }

    @SubscribeEvent
    public void event(RenderGuiOverlayEvent.Pre event) {
        GuiGraphics graphics = event.getGuiGraphics();
        switch (event.getOverlay().id().m_135815_()) {
            case "player_health": {
                InteractionResult result = RenderEvents.RENDER_HEALTH.invoke().render(graphics, (Player)Minecraft.m_91087_().f_91074_);
                if (result != InteractionResult.FAIL) break;
                event.setCanceled(true);
                break;
            }
            case "food_level": {
                InteractionResult result = RenderEvents.RENDER_FOOD.invoke().render(graphics, (Player)Minecraft.m_91087_().f_91074_);
                if (result != InteractionResult.FAIL) break;
                event.setCanceled(true);
                break;
            }
            case "air_level": {
                InteractionResult result = RenderEvents.RENDER_BREATH.invoke().render(graphics, (Player)Minecraft.m_91087_().f_91074_);
                if (result != InteractionResult.FAIL) break;
                event.setCanceled(true);
                break;
            }
            case "vehicle_health": {
                InteractionResult result = RenderEvents.RENDER_MOUNT_HEALTH.invoke().render(graphics, (Player)Minecraft.m_91087_().f_91074_);
                if (result != InteractionResult.FAIL) break;
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void event(ClientPlayerNetworkEvent.LoggingOut event) {
        ClientPlayerEvents.CLIENT_PLAYER_QUIT.invoke().quit(event.getPlayer());
    }
}

