package tocraft.craftedcore.event.common;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import tocraft.craftedcore.event.Event;
import tocraft.craftedcore.event.EventFactory;

@SuppressWarnings("unused")
public final class EntityEvents {
    public static final Event<Interact> INTERACT_WITH_PLAYER = EventFactory.createWithInteractionResult();
    public static final Event<LivingDeath> LIVING_DEATH = EventFactory.createWithInteractionResult();

    @FunctionalInterface
    public interface Interact {
        InteractionResult interact(Player player, Entity entity, InteractionHand hand);
    }

    @FunctionalInterface
    public interface LivingDeath {
        InteractionResult die(LivingEntity entity, DamageSource source);
    }
}
