/*
 * Decompiled with CFR 0.152.
 */
package tocraft.craftedcore.platform;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.platform.Platform;
import java.lang.module.ModuleDescriptor;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.minecraft.network.chat.Component;
import net.minecraft.util.GsonHelper;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import tocraft.craftedcore.CraftedCore;
import tocraft.craftedcore.CraftedCoreConfig;

public class VersionChecker {
    private static final Map<String, ModuleDescriptor.Version> CACHED_VERSION = new HashMap<String, ModuleDescriptor.Version>();
    private static final List<String> INVALID_VERSIONS = List.of("1.16.5", "1.18.2", "1.19.4", "1.20.1", "1.20.2", "1.20.4", "1.20.5");

    public static void registerMavenChecker(String modid, URL mavenURL, Component modName) {
        PlayerEvent.PLAYER_JOIN.register(player -> new Thread(() -> {
            if (CraftedCoreConfig.INSTANCE != null && CraftedCoreConfig.INSTANCE.enableVersionChecking) {
                ModuleDescriptor.Version localVersion;
                ModuleDescriptor.Version newestVersion = localVersion = ModuleDescriptor.Version.parse(Platform.getMod((String)modid).getVersion());
                if (CACHED_VERSION.containsKey(modid)) {
                    newestVersion = CACHED_VERSION.get(modid);
                } else {
                    ArrayList<String> remoteVersions = new ArrayList<String>();
                    try {
                        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                        factory.setIgnoringComments(true);
                        factory.setIgnoringElementContentWhitespace(true);
                        factory.setValidating(false);
                        DocumentBuilder builder = factory.newDocumentBuilder();
                        Document xmlFile = builder.parse(new InputSource(mavenURL.openStream()));
                        NodeList nodeList = xmlFile.getElementsByTagName("version");
                        for (int i = 0; i < nodeList.getLength(); ++i) {
                            remoteVersions.add(nodeList.item(i).getTextContent());
                        }
                    }
                    catch (Exception e) {
                        CraftedCore.LOGGER.error("Caught an error while getting the newest versions from: " + mavenURL, (Throwable)e);
                    }
                    ArrayList<ModuleDescriptor.Version> versions = new ArrayList<ModuleDescriptor.Version>(VersionChecker.processVersionListWithDefaultLayout(remoteVersions, true, INVALID_VERSIONS));
                    if (!versions.isEmpty()) {
                        newestVersion = (ModuleDescriptor.Version)versions.get(versions.size() - 1);
                    }
                    CACHED_VERSION.put(modid, newestVersion);
                }
                if (newestVersion.compareTo(localVersion) > 0) {
                    CraftedCore.LOGGER.warn(Component.m_237110_((String)"craftedcore.update", (Object[])new Object[]{modName, newestVersion}).getString());
                    player.m_213846_((Component)Component.m_237110_((String)"craftedcore.update", (Object[])new Object[]{modName, newestVersion}));
                }
            }
        }, VersionChecker.class.getSimpleName()).start());
    }

    public static void registerDefaultGitHubChecker(String modid, String owner, String repo, Component modName) {
        VersionChecker.registerGitHubChecker(modid, owner, repo, false, true, modName, INVALID_VERSIONS);
    }

    public static void registerGitHubChecker(String modid, String owner, String repo, boolean releasesInsteadOfTags, boolean useLastPartOfVersion, Component modName, List<String> invalidVersions) {
        PlayerEvent.PLAYER_JOIN.register(player -> new Thread(() -> {
            if (CraftedCoreConfig.INSTANCE != null && CraftedCoreConfig.INSTANCE.enableVersionChecking) {
                ModuleDescriptor.Version localVersion;
                ModuleDescriptor.Version newestVersion = localVersion = ModuleDescriptor.Version.parse(Platform.getMod((String)modid).getVersion());
                if (!CACHED_VERSION.containsKey(modid)) {
                    List<String> remoteVersions = VersionChecker.getVersionsFromGitHub(owner, repo, releasesInsteadOfTags);
                    ArrayList<ModuleDescriptor.Version> versions = new ArrayList<ModuleDescriptor.Version>(VersionChecker.processVersionListWithDefaultLayout(remoteVersions, useLastPartOfVersion, invalidVersions));
                    if (!versions.isEmpty()) {
                        newestVersion = (ModuleDescriptor.Version)versions.get(versions.size() - 1);
                    }
                    CACHED_VERSION.put(modid, newestVersion);
                } else {
                    newestVersion = CACHED_VERSION.get(modid);
                }
                if (newestVersion.compareTo(localVersion) > 0) {
                    CraftedCore.LOGGER.warn(Component.m_237110_((String)"craftedcore.update", (Object[])new Object[]{modName, newestVersion}).getString());
                    player.m_213846_((Component)Component.m_237110_((String)"craftedcore.update", (Object[])new Object[]{modName, newestVersion}));
                }
            }
        }, VersionChecker.class.getSimpleName()).start());
    }

    private static List<ModuleDescriptor.Version> processVersionListWithDefaultLayout(List<String> versions, boolean useLast, List<String> invalidVersions) {
        ArrayList<String> sortedVersions = new ArrayList<String>();
        for (String version : versions) {
            String processedVersion;
            if (!version.contains("-") || sortedVersions.contains(processedVersion = version.split("-")[useLast ? 1 : 0]) || invalidVersions.contains(processedVersion)) continue;
            sortedVersions.add(processedVersion);
        }
        return sortedVersions.stream().map(ModuleDescriptor.Version::parse).sorted().toList();
    }

    private static List<String> getVersionsFromGitHub(String owner, String repo, boolean releasesInsteadOfTags) {
        String url = "https://api.github.com/repos/" + owner + "/" + repo + (releasesInsteadOfTags ? "/releases" : "/tags");
        Gson GSON = new GsonBuilder().setPrettyPrinting().create();
        ArrayList<String> versions = new ArrayList<String>();
        try (CloseableHttpClient httpClient = HttpClientBuilder.create().build();){
            HttpGet request = new HttpGet(url);
            request.addHeader("Accept", (Object)"application/vnd.github.v3+json");
            CloseableHttpResponse result = httpClient.execute((ClassicHttpRequest)request);
            String json = EntityUtils.toString((HttpEntity)result.getEntity(), (String)"UTF-8");
            JsonArray jsonArray = (JsonArray)GsonHelper.m_13794_((Gson)GSON, (String)json, JsonArray.class);
            for (JsonElement jsonElement : jsonArray) {
                versions.add(jsonElement.getAsJsonObject().get("name").getAsString());
            }
        }
        catch (Exception e) {
            CraftedCore.LOGGER.error("Caught an error while getting the newest " + (releasesInsteadOfTags ? "releases" : "tags") + " from " + url, (Throwable)e);
        }
        return versions;
    }
}

