/*
 * Decompiled with CFR 0.152.
 */
package tocraft.craftedcore.config;

import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.architectury.event.events.client.ClientPlayerEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tocraft.craftedcore.CraftedCore;
import tocraft.craftedcore.config.Config;
import tocraft.craftedcore.config.SynchronizeStrategy;
import tocraft.craftedcore.config.annotions.Synchronize;

public class ConfigLoader {
    public static final ResourceLocation CONFIG_SYNC = CraftedCore.id("config_sync");
    private static final Map<String, Config> LOADED_CONFIGS = new HashMap<String, Config>();
    private static final List<Config> CLIENT_CONFIGS = new ArrayList<Config>();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Gson SYNC_ONLY_GSON = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new SynchronizeStrategy()).setPrettyPrinting().create();

    public static void registerConfigSyncHandler() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)CONFIG_SYNC, ConfigLoader::handleConfigSyncPackage);
        ClientPlayerEvent.CLIENT_PLAYER_QUIT.register(player -> {
            for (Config config : CLIENT_CONFIGS) {
                for (Config potentiallySynced : LOADED_CONFIGS.values()) {
                    if (!config.getClass().getSimpleName().equals(potentiallySynced.getClass().getSimpleName())) continue;
                    boolean allConfigSyncs = Arrays.stream(config.getClass().getAnnotations()).anyMatch(annotation -> annotation instanceof Synchronize);
                    for (Field field : config.getClass().getDeclaredFields()) {
                        if (!allConfigSyncs && !Arrays.stream(field.getAnnotations()).anyMatch(annotation -> annotation instanceof Synchronize)) continue;
                        try {
                            field.setAccessible(true);
                            Object preSyncValue = field.get(config);
                            field.set(potentiallySynced, preSyncValue);
                        }
                        catch (IllegalAccessException e) {
                            CraftedCore.LOGGER.error("Failed reverting modifications on config " + config.getClass().getSimpleName(), (Throwable)e);
                        }
                    }
                }
            }
            CLIENT_CONFIGS.clear();
        });
    }

    public static <C extends Config> C read(String configName, Class<C> configClass) {
        try {
            Path configFile = ConfigLoader.getConfigPath(configName);
            if (!Files.exists(configFile, new LinkOption[0])) {
                Config config = (Config)configClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                ConfigLoader.writeConfigFile(configFile, config);
                LOADED_CONFIGS.put(configName, config);
                return (C)config;
            }
            Config newConfig = (Config)GSON.fromJson(Files.readString(configFile), configClass);
            if (newConfig == null) {
                newConfig = (Config)configClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                CraftedCore.LOGGER.error("The Configuration '" + configName + ".json' is null. This isn't normal. It will overwritten be with default values.");
            }
            ConfigLoader.writeConfigFile(configFile, newConfig);
            LOADED_CONFIGS.put(configName, newConfig);
            return (C)newConfig;
        }
        catch (Exception e) {
            CraftedCore.LOGGER.error("Failed reading config " + configName, (Throwable)e);
            return null;
        }
    }

    private static <C extends Config> void writeConfigFile(Path file, C config) {
        try {
            if (!Files.exists(file, new LinkOption[0])) {
                Files.createFile(file, new FileAttribute[0]);
            }
            Files.writeString(file, (CharSequence)GSON.toJson(config), new OpenOption[0]);
        }
        catch (IOException e) {
            CraftedCore.LOGGER.error("Failed saving config at " + file, (Throwable)e);
        }
    }

    public static CompoundTag getConfigSyncTag(Config config) {
        CompoundTag configTag = new CompoundTag();
        if (Arrays.stream(config.getClass().getDeclaredAnnotations()).anyMatch(annotation -> annotation instanceof Synchronize)) {
            configTag.m_128359_("ConfigName", config.getClass().getSimpleName());
            configTag.m_128359_("Serialized", GSON.toJson((Object)config));
            configTag.m_128379_("AllSync", true);
        } else {
            configTag.m_128359_("ConfigName", config.getClass().getSimpleName());
            configTag.m_128359_("Serialized", SYNC_ONLY_GSON.toJson((Object)config));
            configTag.m_128379_("AllSync", false);
        }
        return configTag;
    }

    public static void sendConfigSyncPackages(ServerPlayer target) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        CompoundTag tag = new CompoundTag();
        ListTag list = new ListTag();
        for (Config config : LOADED_CONFIGS.values()) {
            list.add((Object)ConfigLoader.getConfigSyncTag(config));
        }
        tag.m_128365_("configs", (Tag)list);
        packet.m_130079_(tag);
        if (!list.isEmpty()) {
            NetworkManager.sendToPlayer((ServerPlayer)target, (ResourceLocation)CONFIG_SYNC, (FriendlyByteBuf)packet);
        }
    }

    private static void handleConfigSyncPackage(FriendlyByteBuf packet, NetworkManager.PacketContext contex) {
        CLIENT_CONFIGS.clear();
        CompoundTag tag = packet.m_130260_();
        if (tag != null && tag.m_128441_("configs")) {
            ListTag list = (ListTag)tag.m_128423_("configs");
            if (list != null) {
                for (Tag compound : list) {
                    ConfigLoader.handleConfigTag((CompoundTag)compound);
                }
            }
        } else if (tag != null && tag.m_128441_("ConfigName")) {
            ConfigLoader.handleConfigTag(tag);
        } else {
            CraftedCore.LOGGER.error("Failed to handle Config Sync Package.");
        }
    }

    private static void handleConfigTag(CompoundTag syncedConfiguration) {
        String name = syncedConfiguration.m_128461_("ConfigName");
        String json = syncedConfiguration.m_128461_("Serialized");
        boolean allSync = syncedConfiguration.m_128471_("AllSync");
        for (Config config : LOADED_CONFIGS.values()) {
            if (!config.getClass().getSimpleName().equals(name)) continue;
            Config serverConfig = (Config)GSON.fromJson(json, config.getClass());
            Config cachedClient = (Config)GSON.fromJson(GSON.toJson((Object)config), config.getClass());
            CLIENT_CONFIGS.add(cachedClient);
            for (Field field : serverConfig.getClass().getDeclaredFields()) {
                if (!allSync && !Arrays.stream(field.getAnnotations()).anyMatch(annotation -> annotation instanceof Synchronize)) continue;
                try {
                    field.setAccessible(true);
                    Object serverValue = field.get(serverConfig);
                    field.set(config, serverValue);
                }
                catch (IllegalAccessException e) {
                    CraftedCore.LOGGER.error("Failed modifying on config " + config.getClass().getSimpleName(), (Throwable)e);
                }
            }
        }
    }

    @Nullable
    public static Config getConfigByName(String configName) {
        return LOADED_CONFIGS.get(configName);
    }

    @NotNull
    public static Path getConfigPath(String configName) {
        return Paths.get(Platform.getConfigFolder().toString(), configName + ".json");
    }

    public static <C extends Config> void writeConfigFile(C config) {
        ConfigLoader.writeConfigFile(ConfigLoader.getConfigPath(config.getName()), config);
    }

    public static <C extends Config> List<String> getConfigNames(C config) {
        return LOADED_CONFIGS.entrySet().stream().filter(entry -> ((Config)entry.getValue()).equals(config)).map(Map.Entry::getKey).toList();
    }
}

