/*
 * Decompiled with CFR 0.152.
 */
package tocraft.craftedcore.platform;

import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.platform.Platform;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.module.ModuleDescriptor;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import tocraft.craftedcore.CraftedCore;
import tocraft.craftedcore.CraftedCoreConfig;

public class VersionChecker {
    private static final Map<String, String> CACHED_VERSION = new HashMap<String, String>();

    public static void registerMavenChecker(String modid, URL mavenURL, Component modName) {
        VersionChecker.registerChecker(modid, mavenURL, "<version>" + Platform.getMinecraftVersion() + "-", "</version>", modName);
    }

    public static void registerChecker(String modid, URL urlToCheck, String linePrefix, String lineSuffix, Component modName) {
        new Thread(() -> VersionChecker.cacheNewestVersion(modid, urlToCheck, linePrefix, lineSuffix)).start();
        PlayerEvent.PLAYER_JOIN.register(player -> {
            String newestVersion;
            String localVersion;
            if (CraftedCoreConfig.INSTANCE != null && CraftedCoreConfig.INSTANCE.enableVersionChecking && !(localVersion = Platform.getMod((String)modid).getVersion()).equals(newestVersion = VersionChecker.cacheNewestVersion(modid, urlToCheck, linePrefix, lineSuffix))) {
                player.m_213846_((Component)Component.m_237110_((String)"craftedcore.update", (Object[])new Object[]{modName, newestVersion}));
            }
        });
    }

    public static String cacheNewestVersion(String modid, URL urlToCheck, String linePrefix, String lineSuffix) {
        if (CACHED_VERSION.get(modid) == null) {
            String localVersion;
            String newestVersion = localVersion = Platform.getMod((String)modid).getVersion();
            try {
                List<String> versions = VersionChecker.checkForNewVersionFromURL(urlToCheck, linePrefix, lineSuffix, localVersion);
                if (!versions.isEmpty()) {
                    newestVersion = versions.get(versions.size() - 1);
                }
            }
            catch (IOException e) {
                CraftedCore.LOGGER.error("Failed to get the newest version for " + modid + " from " + urlToCheck + ".", (Throwable)e);
            }
            CACHED_VERSION.put(modid, newestVersion);
            return newestVersion;
        }
        return CACHED_VERSION.get(modid);
    }

    @Deprecated
    public static String checkForNewVersion(URL urlToCheck, String linePrefix, String lineSuffix) throws IOException {
        List<String> versions = VersionChecker.checkForNewVersionFromURL(urlToCheck, linePrefix, lineSuffix, new String[0]);
        return !versions.isEmpty() ? versions.get(versions.size() - 1) : "";
    }

    public static List<String> checkForNewVersionFromURL(URL mavenURL, String linePrefix, String lineSuffix, String ... localVersions) throws IOException {
        String line;
        ArrayList<String> versions = new ArrayList<String>();
        BufferedReader updateReader = new BufferedReader(new InputStreamReader(mavenURL.openStream(), StandardCharsets.UTF_8));
        while ((line = updateReader.readLine()) != null) {
            if (!(line = line.replaceAll(" ", "").replaceAll("\n", "").replaceAll("\t", "")).startsWith(linePrefix) || !line.endsWith(lineSuffix)) continue;
            versions.add(line.split(linePrefix)[1].split(lineSuffix)[0]);
        }
        updateReader.close();
        versions.addAll(Arrays.asList(localVersions));
        return Arrays.asList(VersionChecker.sortVersions((String[])versions.toArray(String[]::new)));
    }

    public static String[] sortVersions(String ... versions) {
        return (String[])Arrays.stream(versions).map(ModuleDescriptor.Version::parse).sorted().map(ModuleDescriptor.Version::toString).toArray(String[]::new);
    }
}

