/*
 * Decompiled with CFR 0.152.
 */
package tocraft.craftedcore.data;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import tocraft.craftedcore.CraftedCore;
import tocraft.craftedcore.data.PlayerDataProvider;
import tocraft.craftedcore.network.client.ClientNetworking;
import tocraft.craftedcore.registration.PlayerDataRegistry;

public class PlayerDataSynchronizer {
    private static String PLAYER_DATA_SYNC = "player_data_sync";

    public static void registerPacketHandler() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)CraftedCore.id(PLAYER_DATA_SYNC), (packet, context) -> {
            CompoundTag tag = packet.m_130260_();
            ListTag list = (ListTag)tag.m_128423_(PLAYER_DATA_SYNC);
            list.forEach(entry -> ((CompoundTag)entry).m_128431_().forEach(key -> ClientNetworking.runOrQueue(context, player -> ((PlayerDataProvider)player).craftedcore$writeTag((String)key, ((CompoundTag)entry).m_128423_(key)))));
        });
    }

    public static void sync(ServerPlayer player) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        CompoundTag tag = new CompoundTag();
        ListTag list = new ListTag();
        PlayerDataProvider playerData = (PlayerDataProvider)player;
        for (String key : ((PlayerDataProvider)player).craftedcore$keySet()) {
            if (!PlayerDataRegistry.shouldSyncKey(key)) {
                return;
            }
            CompoundTag entry = new CompoundTag();
            entry.m_128365_(key, playerData.craftedcore$readTag(key));
            list.add((Object)entry);
        }
        tag.m_128365_(PLAYER_DATA_SYNC, (Tag)list);
        packet.m_130079_(tag);
        NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)CraftedCore.id(PLAYER_DATA_SYNC), (FriendlyByteBuf)packet);
    }
}

