/*
 * Decompiled with CFR 0.152.
 */
package tocraft.craftedcore.platform;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.UnresolvedAddressException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tocraft.craftedcore.CraftedCore;
import tocraft.craftedcore.util.NetUtils;

public record PlayerProfile(@NotNull String name, @NotNull UUID id, @Nullable URL skin, boolean isSlim, @Nullable URL cape) {
    private static final Map<String, UUID> NAME_TO_UUID_CACHE = new ConcurrentHashMap<String, UUID>();
    private static final Map<UUID, PlayerProfile> UUID_TO_PROFILE_CACHE = new ConcurrentHashMap<UUID, PlayerProfile>();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    @Nullable
    public static UUID getUUID(@NotNull String name) {
        return NAME_TO_UUID_CACHE.computeIfAbsent(name, key -> {
            try {
                JsonElement response = NetUtils.getJsonResponse(GSON, new URI("https://api.mojang.com/users/profiles/minecraft/" + key).toURL());
                if (response == null) {
                    return null;
                }
                JsonObject lookup = response.getAsJsonObject();
                return PlayerProfile.stringToUUID(lookup.get("id").getAsString());
            }
            catch (IOException | URISyntaxException | UnresolvedAddressException e) {
                CraftedCore.LOGGER.error("Caught an exception.", (Throwable)e);
                return null;
            }
        });
    }

    @Nullable
    public static PlayerProfile ofName(@NotNull String name) {
        UUID uuid = PlayerProfile.getUUID(name);
        return uuid != null ? PlayerProfile.ofId(uuid) : null;
    }

    @Nullable
    public static PlayerProfile ofId(@NotNull UUID uuid) {
        return UUID_TO_PROFILE_CACHE.computeIfAbsent(uuid, key -> {
            JsonObject profile;
            try {
                JsonElement response = NetUtils.getJsonResponse(GSON, new URI("https://sessionserver.mojang.com/session/minecraft/profile/" + key.toString().replace("-", "")).toURL());
                if (response == null) {
                    return null;
                }
                profile = response.getAsJsonObject();
            }
            catch (IOException | URISyntaxException | UnresolvedAddressException e) {
                CraftedCore.LOGGER.error("Caught an exception.", (Throwable)e);
                return null;
            }
            JsonArray properties = profile.get("properties").getAsJsonArray();
            JsonObject textures = null;
            for (JsonElement property : properties) {
                JsonObject propertyObject;
                if (!property.isJsonObject() || !Objects.equals((propertyObject = property.getAsJsonObject()).get("name").getAsString(), "textures")) continue;
                String decodedProperties = new String(Base64.getDecoder().decode(propertyObject.get("value").getAsString()), StandardCharsets.UTF_8);
                JsonObject jsonProperties = ((JsonElement)GSON.fromJson(decodedProperties, JsonElement.class)).getAsJsonObject();
                textures = jsonProperties.get("textures").getAsJsonObject();
                break;
            }
            String name = profile.get("name").getAsString();
            URL skin = null;
            boolean isSlim = false;
            URL cape = null;
            if (textures != null) {
                if (textures.has("SKIN")) {
                    JsonObject metadata;
                    JsonObject skinJson = textures.get("SKIN").getAsJsonObject();
                    try {
                        skin = new URI(skinJson.get("url").getAsString()).toURL();
                    }
                    catch (MalformedURLException | URISyntaxException e) {
                        throw new RuntimeException(e);
                    }
                    if (skinJson.has("metadata") && (metadata = skinJson.get("metadata").getAsJsonObject()).has("model")) {
                        isSlim = Objects.equals(metadata.get("model").getAsString(), "slim");
                    }
                }
                if (textures.has("CAPE")) {
                    try {
                        cape = new URI(textures.get("CAPE").getAsJsonObject().get("url").getAsString()).toURL();
                    }
                    catch (MalformedURLException | URISyntaxException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            return new PlayerProfile(name, (UUID)key, skin, isSlim, cape);
        });
    }

    private static UUID stringToUUID(String input) throws IllegalArgumentException {
        try {
            return UUID.fromString(input);
        }
        catch (IllegalArgumentException e) {
            return UUID.fromString(input.replaceFirst("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})", "$1-$2-$3-$4-$5"));
        }
    }
}

