/*
 * Decompiled with CFR 0.152.
 */
package tocraft.craftedcore.network;

import dev.architectury.injectables.annotations.ExpectPlatform;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import tocraft.craftedcore.network.forge.ModernNetworkingImpl;

public class ModernNetworking {
    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerReceiver(Side side, ResourceLocation id, Receiver receiver) {
        void var2_2;
        void var1_1;
        ModernNetworkingImpl.registerReceiver(side, (ResourceLocation)var1_1, (Receiver)var2_2);
    }

    public static void sendToPlayer(ServerPlayer player, ResourceLocation packetId, CompoundTag data) {
        player.f_8906_.m_9829_(ModernNetworking.toPacket(Side.S2C, packetId, data));
    }

    public static void sendToPlayers(Iterable<ServerPlayer> players, ResourceLocation packetId, CompoundTag data) {
        for (ServerPlayer player : players) {
            ModernNetworking.sendToPlayer(player, packetId, data);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void sendToServer(ResourceLocation packetId, CompoundTag data) {
        ClientPacketListener connection = Minecraft.m_91087_().m_91403_();
        if (connection != null) {
            connection.m_104955_(ModernNetworking.toPacket(Side.C2S, packetId, data));
        }
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ApiStatus.Internal
    @ExpectPlatform.Transformed
    public static Packet<?> toPacket(Side side, ResourceLocation id, CompoundTag data) {
        void var2_2;
        void var1_1;
        return ModernNetworkingImpl.toPacket(side, (ResourceLocation)var1_1, (CompoundTag)var2_2);
    }

    public static enum Side {
        S2C,
        C2S;

    }

    public static enum Env {
        CLIENT,
        SERVER;

    }

    public static interface Context {
        public Player getPlayer();

        public Env getEnv();

        public void queue(Runnable var1);
    }

    @FunctionalInterface
    public static interface Receiver {
        public void receive(Context var1, CompoundTag var2);
    }
}

