/*
 * Decompiled with CFR 0.152.
 */
package tocraft.craftedcore.data;

import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import tocraft.craftedcore.CraftedCore;
import tocraft.craftedcore.data.PlayerDataProvider;
import tocraft.craftedcore.network.ModernNetworking;
import tocraft.craftedcore.network.client.ClientNetworking;
import tocraft.craftedcore.patched.CEntity;
import tocraft.craftedcore.registration.PlayerDataRegistry;

public class PlayerDataSynchronizer {
    private static final String PLAYER_DATA_SYNC = "player_data_sync";
    public static final ResourceLocation PLAYER_DATA_SYNC_ID = CraftedCore.id("player_data_sync");

    public static void registerPacketHandler() {
        ModernNetworking.registerReceiver(ModernNetworking.Side.S2C, PLAYER_DATA_SYNC_ID, (context, tag) -> {
            ListTag list;
            if (tag != null && (list = (ListTag)tag.m_128423_(PLAYER_DATA_SYNC)) != null) {
                for (Tag entry : list) {
                    for (String key : ((CompoundTag)entry).m_128431_()) {
                        if (Objects.equals(key, "DELETED")) {
                            ClientNetworking.runOrQueue(context, player -> {
                                PlayerDataProvider playerDataProvider = tag.m_128403_("uuid") ? (PlayerDataProvider)player.m_20193_().m_46003_(tag.m_128342_("uuid")) : (PlayerDataProvider)player;
                                if (playerDataProvider != null) {
                                    playerDataProvider.craftedcore$writeTag(Objects.requireNonNull(((CompoundTag)entry).m_128423_(key)).m_7916_(), null);
                                }
                            });
                            continue;
                        }
                        ClientNetworking.runOrQueue(context, player -> {
                            PlayerDataProvider playerDataProvider = tag.m_128403_("uuid") ? (PlayerDataProvider)player.m_20193_().m_46003_(tag.m_128342_("uuid")) : (PlayerDataProvider)player;
                            if (playerDataProvider != null) {
                                playerDataProvider.craftedcore$writeTag(key, ((CompoundTag)entry).m_128423_(key));
                            }
                        });
                    }
                }
            }
        });
    }

    public static void sync(ServerPlayer player) {
        PlayerDataSynchronizer.syncToSelf(player);
        PlayerDataSynchronizer.syncToAll(player);
    }

    private static void syncToSelf(ServerPlayer player) {
        CompoundTag tag = new CompoundTag();
        ListTag list = new ListTag();
        PlayerDataProvider playerData = (PlayerDataProvider)player;
        for (String key : ((PlayerDataProvider)player).craftedcore$keySet()) {
            if (!PlayerDataRegistry.shouldSyncTagToSelf(key)) {
                return;
            }
            CompoundTag entry = new CompoundTag();
            Tag value = playerData.craftedcore$readTag(key);
            if (value != null) {
                entry.m_128365_(key, value);
            } else {
                entry.m_128365_("DELETED", (Tag)StringTag.m_129297_((String)key));
            }
            list.add((Object)entry);
        }
        tag.m_128365_(PLAYER_DATA_SYNC, (Tag)list);
        ModernNetworking.sendToPlayer(player, PLAYER_DATA_SYNC_ID, tag);
    }

    private static void syncToAll(ServerPlayer player) {
        CompoundTag tag = new CompoundTag();
        ListTag list = new ListTag();
        tag.m_128362_("uuid", player.m_20148_());
        PlayerDataProvider playerData = (PlayerDataProvider)player;
        for (String key : ((PlayerDataProvider)player).craftedcore$keySet()) {
            if (!PlayerDataRegistry.shouldSyncTagToAll(key)) {
                return;
            }
            CompoundTag entry = new CompoundTag();
            Tag value = playerData.craftedcore$readTag(key);
            if (value != null) {
                entry.m_128365_(key, value);
            } else {
                entry.m_128365_("DELETED", (Tag)StringTag.m_129297_((String)key));
            }
            list.add((Object)entry);
        }
        tag.m_128365_(PLAYER_DATA_SYNC, (Tag)list);
        ModernNetworking.sendToPlayers(((ServerLevel)CEntity.level((Entity)player)).m_6907_(), PLAYER_DATA_SYNC_ID, tag);
    }
}

