/*
 * Decompiled with CFR 0.152.
 */
package tocraft.craftedcore.config;

import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.architectury.event.events.client.ClientPlayerEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import tocraft.craftedcore.CraftedCore;
import tocraft.craftedcore.config.Config;
import tocraft.craftedcore.config.SynchronizeStrategy;
import tocraft.craftedcore.config.annotions.Synchronize;

public class ConfigLoader {
    static ResourceLocation CONFIG_SYNC = CraftedCore.id("config_sync");
    private static final List<Config> LOADED_CONFIGS = new ArrayList<Config>();
    private static final List<Config> CLIENT_CONFIGS = new ArrayList<Config>();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Gson SYNC_ONLY_GSON = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new SynchronizeStrategy()).setPrettyPrinting().create();

    public static void registerConfigSyncHandler() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)CONFIG_SYNC, ConfigLoader::handleConfigSyncPackage);
        ClientPlayerEvent.CLIENT_PLAYER_QUIT.register(player -> {
            for (Config config : CLIENT_CONFIGS) {
                for (Config potentiallySynced : LOADED_CONFIGS) {
                    if (!config.getClass().getSimpleName().equals(potentiallySynced.getClass().getSimpleName())) continue;
                    boolean allConfigSyncs = Arrays.stream(config.getClass().getAnnotations()).anyMatch(annotation -> annotation instanceof Synchronize);
                    for (Field field : config.getClass().getDeclaredFields()) {
                        if (!allConfigSyncs && !Arrays.stream(field.getAnnotations()).anyMatch(annotation -> annotation instanceof Synchronize)) continue;
                        try {
                            field.setAccessible(true);
                            Object preSyncValue = field.get(config);
                            field.set(potentiallySynced, preSyncValue);
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            CLIENT_CONFIGS.clear();
        });
    }

    public static <C extends Config> C read(String configName, Class<C> configClass) {
        try {
            Path configFolder = Platform.getConfigFolder();
            Path configFile = Paths.get(configFolder.toString(), configName + ".json");
            if (!Files.exists(configFile, new LinkOption[0])) {
                Config config = (Config)configClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                ConfigLoader.writeConfigFile(configFile, config);
                LOADED_CONFIGS.add(config);
                return (C)config;
            }
            Config newConfig = (Config)GSON.fromJson(Files.readString(configFile), configClass);
            ConfigLoader.writeConfigFile(configFile, newConfig);
            LOADED_CONFIGS.add(newConfig);
            return (C)newConfig;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static <C extends Config> void writeConfigFile(Path file, C config) {
        try {
            if (!Files.exists(file, new LinkOption[0])) {
                Files.createFile(file, new FileAttribute[0]);
            }
            Files.writeString(file, (CharSequence)GSON.toJson(config), new OpenOption[0]);
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    public static <C extends Config> void sendConfigSyncPackages(ServerPlayer target) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        CompoundTag tag = new CompoundTag();
        ListTag list = new ListTag();
        for (Config config : LOADED_CONFIGS) {
            CompoundTag configTag = new CompoundTag();
            if (Arrays.stream(config.getClass().getDeclaredAnnotations()).anyMatch(annotation -> annotation instanceof Synchronize)) {
                configTag.m_128359_("ConfigName", config.getClass().getSimpleName());
                configTag.m_128359_("Serialized", GSON.toJson((Object)config));
                configTag.m_128379_("AllSync", true);
            } else {
                configTag.m_128359_("ConfigName", config.getClass().getSimpleName());
                configTag.m_128359_("Serialized", SYNC_ONLY_GSON.toJson((Object)config));
                configTag.m_128379_("AllSync", false);
            }
            list.add((Object)configTag);
        }
        tag.m_128365_("configs", (Tag)list);
        packet.m_130079_(tag);
        if (!list.isEmpty()) {
            NetworkManager.sendToPlayer((ServerPlayer)target, (ResourceLocation)CONFIG_SYNC, (FriendlyByteBuf)packet);
        }
    }

    private static void handleConfigSyncPackage(FriendlyByteBuf packet, NetworkManager.PacketContext contex) {
        CLIENT_CONFIGS.clear();
        CompoundTag tag = packet.m_130260_();
        ListTag list = (ListTag)tag.m_128423_("configs");
        list.forEach(compound -> {
            CompoundTag syncedConfiguration = (CompoundTag)compound;
            String name = syncedConfiguration.m_128461_("ConfigName");
            String json = syncedConfiguration.m_128461_("Serialized");
            boolean allSync = syncedConfiguration.m_128471_("AllSync");
            for (Config config : LOADED_CONFIGS) {
                if (!config.getClass().getSimpleName().equals(name)) continue;
                Config serverConfig = (Config)GSON.fromJson(json, config.getClass());
                Config cachedClient = (Config)GSON.fromJson(GSON.toJson((Object)config), config.getClass());
                CLIENT_CONFIGS.add(cachedClient);
                for (Field field : serverConfig.getClass().getDeclaredFields()) {
                    if (!allSync && !Arrays.stream(field.getAnnotations()).anyMatch(annotation -> annotation instanceof Synchronize)) continue;
                    try {
                        field.setAccessible(true);
                        Object serverValue = field.get(serverConfig);
                        field.set(config, serverValue);
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }
}

