/*
 * Decompiled with CFR 0.152.
 */
package tocraft.craftedcore;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import tocraft.craftedcore.CraftedCore;

public class VIPs {
    public static final String patreonURL = "https://tocraft.dev/patreons.txt";
    private static final List<UUID> CACHED_PATREONS = new ArrayList<UUID>();

    public static List<UUID> getCachedPatreons() {
        if (CACHED_PATREONS.isEmpty()) {
            CACHED_PATREONS.addAll(VIPs.getPatreons());
        }
        return CACHED_PATREONS;
    }

    public static List<UUID> getPatreons() {
        try {
            return VIPs.getUUIDOfPeople(new URI(patreonURL).toURL());
        }
        catch (Exception e) {
            CraftedCore.LOGGER.error("Couldn't get patreons from https://tocraft.dev/patreons.txt");
            CraftedCore.LOGGER.error(e.getLocalizedMessage());
            return new ArrayList<UUID>();
        }
    }

    public static List<UUID> getUUIDOfPeople(URL url) throws IOException {
        String line;
        BufferedReader updateReader = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));
        ArrayList<UUID> people = new ArrayList<UUID>();
        while ((line = updateReader.readLine()) != null) {
            if ((line = line.replaceAll("/n", "").replaceAll(" ", "")).isBlank()) continue;
            people.add(UUID.fromString(line));
        }
        updateReader.close();
        return people;
    }
}

