/*
 * Decompiled with CFR 0.152.
 */
package tocraft.craftedcore.network.forge;

import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.event.EventNetworkChannel;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;
import tocraft.craftedcore.CraftedCore;
import tocraft.craftedcore.network.ModernNetworking;

public class ModernNetworkingImpl {
    private static final ResourceLocation CHANNEL_ID = CraftedCore.id("network");
    private static final EventNetworkChannel CHANNEL = NetworkRegistry.newEventChannel((ResourceLocation)CHANNEL_ID, () -> "1", version -> true, version -> true);
    private static final Map<ResourceLocation, ModernNetworking.Receiver> C2S_RECEIVER = new HashMap<ResourceLocation, ModernNetworking.Receiver>();
    private static final Map<ResourceLocation, ModernNetworking.Receiver> S2C_RECEIVER = new HashMap<ResourceLocation, ModernNetworking.Receiver>();

    public static void initialize() {
        CHANNEL.addListener(event -> {
            FriendlyByteBuf buf = event.getPayload();
            final NetworkEvent.Context source = (NetworkEvent.Context)event.getSource().get();
            if (buf == null || source.getPacketHandled()) {
                return;
            }
            ResourceLocation packetId = buf.m_130281_();
            CompoundTag payload = buf.m_130260_();
            ModernNetworking.Context context = new ModernNetworking.Context(){

                @Override
                public Player getPlayer() {
                    return this.getEnv() == ModernNetworking.Env.CLIENT ? (Player)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.m_91087_().f_91074_) : source.getSender();
                }

                @Override
                public ModernNetworking.Env getEnv() {
                    return source.getDirection().getReceptionSide() == LogicalSide.CLIENT ? ModernNetworking.Env.CLIENT : ModernNetworking.Env.SERVER;
                }

                @Override
                public void queue(Runnable runnable) {
                    source.enqueueWork(runnable);
                }
            };
            ModernNetworking.Receiver receiver = context.getEnv() == ModernNetworking.Env.CLIENT ? S2C_RECEIVER.get(packetId) : C2S_RECEIVER.get(packetId);
            receiver.receive(context, payload);
            source.setPacketHandled(true);
        });
    }

    public static void registerReceiver(ModernNetworking.Side side, ResourceLocation id, ModernNetworking.Receiver receiver) {
        if (side == ModernNetworking.Side.C2S) {
            C2S_RECEIVER.put(id, receiver);
        } else if (side == ModernNetworking.Side.S2C) {
            S2C_RECEIVER.put(id, receiver);
        }
    }

    @ApiStatus.Internal
    public static Packet<?> toPacket(ModernNetworking.Side side, ResourceLocation id, CompoundTag data) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130085_(id);
        buf.m_130079_(data);
        NetworkDirection direction = side == ModernNetworking.Side.C2S ? NetworkDirection.PLAY_TO_SERVER : NetworkDirection.PLAY_TO_CLIENT;
        return direction.buildPacket(Pair.of((Object)buf, (Object)0), CHANNEL_ID).getThis();
    }
}

