/*
 * Decompiled with CFR 0.152.
 */
package tocraft.craftedcore.gui;

import com.mojang.blaze3d.platform.NativeImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import tocraft.craftedcore.CraftedCore;
import tocraft.craftedcore.patched.Identifier;

@OnlyIn(value=Dist.CLIENT)
public class TextureCache {
    private static final Map<String, ResourceLocation> TEXTURE_CACHE = new ConcurrentHashMap<String, ResourceLocation>();

    @Nullable
    public static ResourceLocation getTextureId(String namespace, String type, String prefix, String fileType, URL textureURL) {
        return TEXTURE_CACHE.computeIfAbsent(String.valueOf(textureURL), key -> {
            ResourceLocation id = Identifier.parse(namespace, "textures/" + type + "/" + prefix + key.hashCode() + "." + fileType);
            try (InputStream is = textureURL.openStream();){
                NativeImage image = NativeImage.m_85058_((InputStream)new ByteArrayInputStream(is.readAllBytes()));
                DynamicTexture dynamicTexture = new DynamicTexture(image);
                Minecraft.m_91087_().m_91097_().m_118495_(id, (AbstractTexture)dynamicTexture);
            }
            catch (IOException e) {
                CraftedCore.LOGGER.error("Caught an exception while reading url: {}", (Object)textureURL, (Object)e);
                return null;
            }
            return id;
        });
    }
}

