/*
 * Decompiled with CFR 0.152.
 */
package tocraft.craftedcore.forge.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tocraft.craftedcore.event.common.EntityEvents;

@Mixin(value={LivingEntity.class})
public abstract class LivingBreatheMixin
extends Entity {
    public LivingBreatheMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Shadow
    public abstract boolean m_6084_();

    @Shadow
    protected abstract int m_7305_(int var1);

    @Shadow
    protected abstract int m_7302_(int var1);

    @Inject(method={"increaseAirSupply"}, at={@At(value="RETURN")}, cancellable=true)
    private void onIncreaseAirSupply(int currentAir, CallbackInfoReturnable<Integer> cir) {
        if (!EntityEvents.LIVING_BREATHE.invoke().breathe((LivingEntity)this, true)) {
            cir.setReturnValue((Object)currentAir);
        }
    }

    @Inject(method={"decreaseAirSupply"}, at={@At(value="RETURN")}, cancellable=true)
    private void onDecreaseAirSupply(int currentAir, CallbackInfoReturnable<Integer> cir) {
        if (EntityEvents.LIVING_BREATHE.invoke().breathe((LivingEntity)this, false)) {
            cir.setReturnValue((Object)currentAir);
        }
    }

    @Inject(method={"baseTick"}, at={@At(value="HEAD")})
    private void breathe(CallbackInfo ci) {
        boolean isInWater = this.m_204029_(FluidTags.f_13131_) && !this.f_19853_.m_8055_(new BlockPos(this.m_20185_(), this.m_20188_(), this.m_20189_())).m_60713_(Blocks.f_50628_);
        int air = this.m_20146_();
        boolean canBreathe = EntityEvents.LIVING_BREATHE.invoke().breathe((LivingEntity)this, !isInWater);
        if (this.m_6084_()) {
            if (!isInWater && !canBreathe) {
                this.m_20301_(this.m_7302_(air));
                if (this.m_20146_() == -20) {
                    this.m_20301_(0);
                    this.m_6469_(DamageSource.f_19324_, 2.0f);
                }
            } else if (canBreathe && isInWater) {
                this.m_20301_(this.m_7305_(air));
            }
        }
    }
}

