/*
 * Decompiled with CFR 0.152.
 */
package tocraft.craftedcore.data;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import tocraft.craftedcore.CraftedCore;
import tocraft.craftedcore.network.ModernNetworking;
import tocraft.craftedcore.patched.Identifier;
import tocraft.craftedcore.platform.PlatformData;

public abstract class SynchronizedJsonReloadListener
extends SimpleJsonResourceReloadListener {
    public final ResourceLocation RELOAD_SYNC;
    protected final String directory;
    protected final Gson gson;
    private final Map<ResourceLocation, JsonElement> map = new HashMap<ResourceLocation, JsonElement>();

    public SynchronizedJsonReloadListener(Gson gson, String directory) {
        super(gson, directory);
        this.gson = gson;
        this.directory = directory;
        this.RELOAD_SYNC = CraftedCore.id("data_sync_" + directory);
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profiler) {
        this.map.clear();
        this.map.putAll(map);
        this.onApply(map);
    }

    protected abstract void onApply(Map<ResourceLocation, JsonElement> var1);

    public void sendSyncPacket(ServerPlayer player) {
        CompoundTag compound = new CompoundTag();
        this.map.forEach((key, json) -> compound.m_128359_(key.toString(), json.toString()));
        ModernNetworking.sendToPlayer(player, this.RELOAD_SYNC, compound);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void onPacketReceive(ModernNetworking.Context context, CompoundTag compound) {
        this.map.clear();
        if (compound != null) {
            for (String key : compound.m_128431_()) {
                this.map.put(Identifier.parse(key), JsonParser.parseString((String)compound.m_128461_(key)));
            }
        }
        if (PlatformData.getEnv() == Dist.CLIENT) {
            this.onApply(this.map);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerPacketReceiver() {
        ModernNetworking.registerReceiver(ModernNetworking.Side.S2C, this.RELOAD_SYNC, this::onPacketReceive);
    }
}

