/*
 * Decompiled with CFR 0.152.
 */
package tocraft.craftedcore.config;

import java.nio.file.Path;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.Nullable;
import tocraft.craftedcore.config.ConfigLoader;
import tocraft.craftedcore.network.ModernNetworking;

public interface Config {
    @Nullable
    default public String getName() {
        List<String> possibleNames = ConfigLoader.getConfigNames(this);
        return !possibleNames.isEmpty() ? possibleNames.get(0) : null;
    }

    @Nullable
    default public Path getPath() {
        return this.getName() != null ? ConfigLoader.getConfigPath(this.getName()) : null;
    }

    default public void save() {
        ConfigLoader.writeConfigFile(this);
    }

    default public void sendToPlayer(ServerPlayer target) {
        ModernNetworking.sendToPlayer(target, ConfigLoader.CONFIG_SYNC, ConfigLoader.getConfigSyncTag(this));
    }

    default public void sendToAllPlayers(ServerLevel serverLevel) {
        for (ServerPlayer target : serverLevel.m_6907_()) {
            this.sendToPlayer(target);
        }
    }
}

