/*
 * Decompiled with CFR 0.152.
 */
package tocraft.craftedcore;

import com.llamalad7.mixinextras.MixinExtrasBootstrap;
import java.util.concurrent.CompletableFuture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tocraft.craftedcore.VIPs;
import tocraft.craftedcore.config.ConfigLoader;
import tocraft.craftedcore.data.PlayerDataSynchronizer;
import tocraft.craftedcore.event.common.PlayerEvents;
import tocraft.craftedcore.patched.CEntity;
import tocraft.craftedcore.patched.Identifier;
import tocraft.craftedcore.patched.TComponent;
import tocraft.craftedcore.platform.VersionChecker;
import tocraft.craftedcore.registration.SynchronizedReloadListenerRegistry;

public class CraftedCore {
    public static final Logger LOGGER = LoggerFactory.getLogger(CraftedCore.class);
    public static final String MODID = "craftedcore";
    private static boolean hasReportedNoInternet = false;

    public void initialize() {
        MixinExtrasBootstrap.init();
        CompletableFuture.runAsync(VIPs::cachePatreons);
        PlayerEvents.PLAYER_JOIN.register(ConfigLoader::sendConfigSyncPackages);
        PlayerEvents.PLAYER_JOIN.register(player -> {
            for (ServerPlayer serverPlayer : ((ServerLevel)CEntity.level((Entity)player)).m_6907_()) {
                PlayerDataSynchronizer.sync(serverPlayer);
            }
        });
        SynchronizedReloadListenerRegistry.initialize();
        VersionChecker.registerModrinthChecker(MODID, "crafted-core", (Component)TComponent.literal("CraftedCore"));
    }

    public static void reportMissingInternet(Throwable cause) {
        if (!hasReportedNoInternet) {
            LOGGER.error("No internet connection!", cause);
            hasReportedNoInternet = true;
        }
    }

    public static ResourceLocation id(String name) {
        return Identifier.parse(MODID, name);
    }
}

