/*
 * Decompiled with CFR 0.152.
 */
package tocraft.craftedcore.registration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import tocraft.craftedcore.data.SynchronizedJsonReloadListener;
import tocraft.craftedcore.platform.PlatformData;

public class SynchronizedReloadListenerRegistry {
    private static final Map<ResourceLocation, SynchronizedJsonReloadListener> listener = new HashMap<ResourceLocation, SynchronizedJsonReloadListener>();

    public static void register(SynchronizedJsonReloadListener reloadListener, ResourceLocation id) {
        listener.put(id, reloadListener);
        if (PlatformData.getEnv() == Dist.CLIENT) {
            reloadListener.registerPacketReceiver();
        }
    }

    public static List<SynchronizedJsonReloadListener> getAllListener() {
        return new ArrayList<SynchronizedJsonReloadListener>(listener.values());
    }

    public static SynchronizedJsonReloadListener get(ResourceLocation id) {
        return listener.get(id);
    }

    public static void sendAllToPlayer(ServerPlayer player) {
        for (SynchronizedJsonReloadListener reloadListener : listener.values()) {
            reloadListener.sendSyncPacket(player);
        }
    }
}

