/*
 * Decompiled with CFR 0.152.
 */
package tocraft.craftedcore.network;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class ModernNetworking {
    public static void registerReceiver(Side side, ResourceLocation id, Receiver receiver) {
        NetworkManager.registerReceiver((NetworkManager.Side)(side == Side.C2S ? NetworkManager.Side.C2S : NetworkManager.Side.S2C), (ResourceLocation)id, (packet, context) -> receiver.receive(new Context(){

            @Override
            public Player getPlayer() {
                return context.getPlayer();
            }

            @Override
            public Dist getEnv() {
                return context.getEnv();
            }

            @Override
            public void queue(Runnable runnable) {
                context.queue(runnable);
            }
        }, packet.m_130260_()));
    }

    public static void sendToPlayer(ServerPlayer player, ResourceLocation packetId, CompoundTag data) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130079_(data);
        NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)packetId, (FriendlyByteBuf)buf);
    }

    public static void sendToPlayers(Iterable<ServerPlayer> players, ResourceLocation packetId, CompoundTag data) {
        for (ServerPlayer player : players) {
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            buf.m_130079_(data);
            NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)packetId, (FriendlyByteBuf)buf);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void sendToServer(ResourceLocation packetId, CompoundTag data) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130079_(data);
        NetworkManager.sendToServer((ResourceLocation)packetId, (FriendlyByteBuf)buf);
    }

    public static enum Side {
        S2C,
        C2S;

    }

    @FunctionalInterface
    public static interface Receiver {
        public void receive(Context var1, CompoundTag var2);
    }

    public static interface Context {
        public Player getPlayer();

        public Dist getEnv();

        public void queue(Runnable var1);
    }
}

