/*
 * Decompiled with CFR 0.152.
 */
package tocraft.craftedcore.mixin;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tocraft.craftedcore.data.PlayerDataProvider;
import tocraft.craftedcore.registration.PlayerDataRegistry;

@Mixin(value={Player.class})
public abstract class PlayerMixin
implements PlayerDataProvider {
    @Unique
    private final Map<String, Tag> craftedcore$playerData = new HashMap<String, Tag>();

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="RETURN")})
    private void readNbt(CompoundTag tag, CallbackInfo info) {
        for (String key : PlayerDataRegistry.keySet()) {
            this.craftedcore$playerData.put(key, tag.m_128423_(key));
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="RETURN")})
    private void writeNbt(CompoundTag tag, CallbackInfo info) {
        this.craftedcore$playerData.forEach((key, value) -> tag.m_128365_(key, this.craftedcore$readTag((String)key)));
    }

    @Override
    @Unique
    public Set<String> craftedcore$keySet() {
        return this.craftedcore$playerData.keySet();
    }

    @Override
    @Unique
    public void craftedcore$writeTag(String key, Tag tag) {
        if (!PlayerDataRegistry.keySet().contains(key)) {
            PlayerDataRegistry.registerKey(key, false);
        }
        this.craftedcore$playerData.put(key, tag);
    }

    @Override
    @Unique
    public Tag craftedcore$readTag(String key) {
        return this.craftedcore$playerData.get(key);
    }
}

