/*
 * Decompiled with CFR 0.152.
 */
package tocraft.craftedcore.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class TimerOverlayRenderer {
    private static final int fadingTickRequirement = 0;
    private static int lastCooldown = 0;
    private static int ticksSinceUpdate = 0;
    private static boolean isFading = false;
    private static int fadingProgress = 0;

    public static void register(PoseStack graphics, int currentCooldown, int maxCooldown, Item item) {
        Minecraft client = Minecraft.m_91087_();
        if (client.f_91080_ instanceof ChatScreen || currentCooldown <= 0 || item == null) {
            return;
        }
        double d = client.m_91268_().m_85449_();
        float cooldownScale = 1.0f - (float)currentCooldown / (float)maxCooldown;
        if (currentCooldown == lastCooldown) {
            if (++ticksSinceUpdate > 0 && !isFading) {
                isFading = true;
                fadingProgress = 0;
            }
        } else if (ticksSinceUpdate > fadingProgress) {
            ticksSinceUpdate = 0;
            isFading = false;
        }
        fadingProgress = isFading ? Math.min(50, fadingProgress + 1) : Math.max(0, fadingProgress - 1);
        if (client.f_91074_ != null) {
            int width = Minecraft.m_91087_().m_91268_().m_85445_();
            int height = Minecraft.m_91087_().m_91268_().m_85446_();
            graphics.m_85836_();
            if (cooldownScale != 1.0f) {
                RenderSystem.m_69488_((int)((int)(0.0 * d)), (int)((int)(0.0 * d)), (int)((int)((double)width * d)), (int)((int)((double)height * (0.02 + 0.055 * (double)cooldownScale) * d)));
            }
            if (isFading) {
                float fadeScalar = (float)fadingProgress / 50.0f;
                float scale = 1.0f + (float)Math.sin((double)fadeScalar * 1.5 * Math.PI) - 0.25f;
                scale = Math.max(scale, 0.0f);
                graphics.m_85841_(scale, scale, scale);
            }
            ItemStack stack = new ItemStack((ItemLike)item);
            Minecraft.m_91087_().m_91291_().m_115123_(stack, (int)((float)width * 0.95f), (int)((float)height * 0.92f));
            RenderSystem.m_69471_();
            graphics.m_85849_();
        }
    }
}

