/*
 * Decompiled with CFR 0.152.
 */
package tocraft.craftedcore.forge.client;

import net.minecraft.client.Minecraft;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.gui.IIngameOverlay;
import net.minecraftforge.client.gui.OverlayRegistry;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import tocraft.craftedcore.event.client.RenderEvents;

@OnlyIn(value=Dist.CLIENT)
public class CraftedCoreForgeEventHandlerClient {
    @SubscribeEvent
    public void eventRenderGameOverlayEvent(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            RenderEvents.HUD_RENDERING.invoke().render(event.getMatrixStack(), event.getPartialTicks());
        }
    }

    @SubscribeEvent
    public void event(RenderGameOverlayEvent.PreLayer event) {
        OverlayRegistry.OverlayEntry overlayEntry = OverlayRegistry.getEntry((IIngameOverlay)event.getOverlay());
        if (overlayEntry != null) {
            switch (overlayEntry.getDisplayName()) {
                case "Player Health": {
                    InteractionResult result = RenderEvents.RENDER_HEALTH.invoke().render(event.getMatrixStack(), (Player)Minecraft.m_91087_().f_91074_);
                    if (result != InteractionResult.FAIL) break;
                    event.setCanceled(true);
                    break;
                }
                case "Food Level": {
                    InteractionResult result = RenderEvents.RENDER_FOOD.invoke().render(event.getMatrixStack(), (Player)Minecraft.m_91087_().f_91074_);
                    if (result != InteractionResult.FAIL) break;
                    event.setCanceled(true);
                    break;
                }
                case "Air Level": {
                    InteractionResult result = RenderEvents.RENDER_BREATH.invoke().render(event.getMatrixStack(), (Player)Minecraft.m_91087_().f_91074_);
                    if (result != InteractionResult.FAIL) break;
                    event.setCanceled(true);
                    break;
                }
                case "Mount Health": {
                    InteractionResult result = RenderEvents.RENDER_MOUNT_HEALTH.invoke().render(event.getMatrixStack(), (Player)Minecraft.m_91087_().f_91074_);
                    if (result != InteractionResult.FAIL) break;
                    event.setCanceled(true);
                }
            }
        }
    }
}

