/*
 * Decompiled with CFR 0.152.
 */
package tocraft.craftedcore.event;

import com.mojang.brigadier.CommandDispatcher;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.InteractionEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import tocraft.craftedcore.event.client.ClientTickEvents;
import tocraft.craftedcore.event.common.CommandEvents;
import tocraft.craftedcore.event.common.EntityEvents;
import tocraft.craftedcore.event.common.ServerLevelEvents;

public final class ArchitecturyImpl {
    public static void initialize() {
        LifecycleEvent.SERVER_LEVEL_LOAD.register(world -> ServerLevelEvents.LEVEL_LOAD.invoke().call((ServerLevel)world));
        LifecycleEvent.SERVER_LEVEL_UNLOAD.register(world -> ServerLevelEvents.LEVEL_UNLOAD.invoke().call((ServerLevel)world));
        InteractionEvent.INTERACT_ENTITY.register((player, entity, hand) -> ArchitecturyImpl.convertInteractionToEventResult(EntityEvents.INTERACT_WITH_PLAYER.invoke().interact(player, entity, hand)));
        CommandRegistrationEvent.EVENT.register((dispatcher, selection) -> CommandEvents.REGISTRATION.invoke().register((CommandDispatcher<CommandSourceStack>)dispatcher, selection));
    }

    @ApiStatus.Internal
    private static EventResult convertInteractionToEventResult(InteractionResult result) {
        if (result == InteractionResult.FAIL) {
            return EventResult.interruptFalse();
        }
        if (result == InteractionResult.SUCCESS) {
            return EventResult.interruptTrue();
        }
        return EventResult.pass();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void clientInitialize() {
        ClientTickEvent.CLIENT_PRE.register(instance -> ClientTickEvents.CLIENT_PRE.invoke().tick((Minecraft)instance));
        ClientTickEvent.CLIENT_POST.register(instance -> ClientTickEvents.CLIENT_POST.invoke().tick((Minecraft)instance));
        ClientTickEvent.CLIENT_LEVEL_PRE.register(instance -> ClientTickEvents.CLIENT_LEVEL_PRE.invoke().tick((ClientLevel)instance));
        ClientTickEvent.CLIENT_LEVEL_POST.register(instance -> ClientTickEvents.CLIENT_LEVEL_POST.invoke().tick((ClientLevel)instance));
    }
}

