/*
 * Decompiled with CFR 0.152.
 */
package tocraft.craftedcore.client;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import tocraft.craftedcore.config.ConfigLoader;
import tocraft.craftedcore.data.PlayerDataSynchronizer;
import tocraft.craftedcore.event.ArchitecturyImpl;
import tocraft.craftedcore.event.client.ClientPlayerEvents;
import tocraft.craftedcore.network.client.ClientNetworking;

@OnlyIn(value=Dist.CLIENT)
public class CraftedCoreClient {
    private static final Set<ClientNetworking.ApplicablePacket> SYNC_PACKET_QUEUE = new HashSet<ClientNetworking.ApplicablePacket>();

    public void initialize() {
        ArchitecturyImpl.clientInitialize();
        ConfigLoader.registerConfigSyncHandler();
        PlayerDataSynchronizer.registerPacketHandler();
        ClientPlayerEvents.CLIENT_PLAYER_JOIN.register(player -> {
            for (ClientNetworking.ApplicablePacket packet : CraftedCoreClient.getSyncPacketQueue()) {
                packet.apply((Player)player);
            }
            CraftedCoreClient.getSyncPacketQueue().clear();
        });
    }

    public static Set<ClientNetworking.ApplicablePacket> getSyncPacketQueue() {
        return SYNC_PACKET_QUEUE;
    }
}

