/*
 * Decompiled with CFR 0.152.
 */
package tocraft.craftedcore;

import com.mojang.util.UUIDTypeAdapter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import tocraft.craftedcore.CraftedCore;
import tocraft.craftedcore.CraftedCoreConfig;
import tocraft.craftedcore.platform.PlatformData;

public class VIPs {
    public static final String patreonURL = "https://raw.githubusercontent.com/ToCraft/craftedcore/1.20.2/common/src/main/resources/patreons.txt";
    private static final List<UUID> CACHED_PATREONS = new ArrayList<UUID>();

    public static List<UUID> getCachedPatreons() {
        return CACHED_PATREONS;
    }

    public static List<UUID> cachePatreons() {
        if (CACHED_PATREONS.isEmpty()) {
            CACHED_PATREONS.addAll(VIPs.getPatreons());
        }
        if (CraftedCoreConfig.INSTANCE != null && CraftedCoreConfig.INSTANCE.savePatreonsLocal) {
            if (CACHED_PATREONS.isEmpty()) {
                CACHED_PATREONS.addAll(CraftedCoreConfig.INSTANCE.localPatreonsList);
            } else {
                CraftedCoreConfig.INSTANCE.localPatreonsList = CACHED_PATREONS;
                CraftedCoreConfig.INSTANCE.save();
            }
        }
        return CACHED_PATREONS;
    }

    public static List<UUID> getPatreons() {
        ArrayList<UUID> patreons = new ArrayList<UUID>();
        try {
            URL localPatreons = CraftedCore.class.getResource("/patreons.txt");
            if (localPatreons != null) {
                for (UUID uuidOfPerson : VIPs.getUUIDOfPeople(localPatreons)) {
                    if (patreons.contains(uuidOfPerson)) continue;
                    patreons.add(uuidOfPerson);
                }
            }
            for (UUID uuidOfPerson : VIPs.getUUIDOfPeople(new URI(patreonURL).toURL())) {
                if (patreons.contains(uuidOfPerson)) continue;
                patreons.add(uuidOfPerson);
            }
        }
        catch (MalformedURLException | URISyntaxException e) {
            CraftedCore.LOGGER.error("Invalid patreon url: https://raw.githubusercontent.com/ToCraft/craftedcore/1.20.2/common/src/main/resources/patreons.txt", (Throwable)e);
        }
        return patreons;
    }

    public static List<UUID> getUUIDOfPeople(URL url) {
        ArrayList<UUID> people = new ArrayList<UUID>();
        try {
            String line;
            BufferedReader updateReader = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));
            while ((line = updateReader.readLine()) != null && !(line = line.replaceAll("\n", "").replaceAll("\r", "")).isBlank()) {
                people.add(UUID.fromString(line));
            }
            updateReader.close();
        }
        catch (IOException e) {
            CraftedCore.LOGGER.error("Couldn't get patreons from https://raw.githubusercontent.com/ToCraft/craftedcore/1.20.2/common/src/main/resources/patreons.txt", (Throwable)e);
        }
        if (PlatformData.getEnv() == Dist.CLIENT && people.contains(UUIDTypeAdapter.fromString((String)Minecraft.m_91087_().m_91094_().m_92545_()))) {
            CraftedCore.LOGGER.info("Thank you for supporting me and my mods! ~To_Craft");
        }
        return people;
    }
}

