package tocraft.craftedcore.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class TimerOverlayRenderer {

    private static final int fadingTickRequirement = 0;
    private static int lastCooldown = 0;
    private static int ticksSinceUpdate = 0;
    private static boolean isFading = false;
    private static int fadingProgress = 0;

    public static void register(PoseStack graphics, int currentCooldown, int maxCooldown, Item item) {
        Minecraft client = Minecraft.m_91087_();

        if (client.f_91080_ instanceof ChatScreen || currentCooldown <= 0 || item == null) {
            return;
        }

        double d = client.m_91268_().m_85449_();
        float cooldownScale = 1 - currentCooldown / (float) maxCooldown;

        // cooldown has NOT updated since last tick. It is most likely full.
        if (currentCooldown == lastCooldown) {
            ticksSinceUpdate++;

            // If the cooldown has not updated, we are above the requirement, and we are not fading, start fading.
            if (ticksSinceUpdate > fadingTickRequirement && !isFading) {
                isFading = true;
                fadingProgress = 0;
            }
        }

        // cooldown updated in the last tick, and we are fading. Stop fading.
        else if (ticksSinceUpdate > fadingProgress) {
            ticksSinceUpdate = 0;
            isFading = false;
        }

        // Tick fading
        if (isFading) {
            fadingProgress = Math.min(50, fadingProgress + 1);
        } else {
            fadingProgress = Math.max(0, fadingProgress - 1);
        }

        if (client.f_91074_ != null) {
            int width = Minecraft.m_91087_().m_91268_().m_85445_();
            int height = Minecraft.m_91087_().m_91268_().m_85446_();

            graphics.m_85836_();
            if (cooldownScale != 1) {
                RenderSystem.m_69488_(
                        (int) ((double) 0 * d),
                        (int) ((double) 0 * d),
                        (int) ((double) width * d),
                        (int) ((double) height * (.02 + .055 * cooldownScale) * d)); // min is 0.21, max is 0.76. dif = .55
            }

            // ending pop
            if (isFading) {
                float fadeScalar = fadingProgress / 50f; // 0f -> 1f, 0 is start, 1 is end
                float scale = 1f + (float) Math.sin(fadeScalar * 1.5 * Math.PI) - .25f;
                scale = Math.max(scale, 0);
                graphics.m_85841_(scale, scale, scale);
            }

            ItemStack stack = new ItemStack(item);
            Minecraft.m_91087_().m_91291_().m_115123_(stack, (int) (width * .95f), (int) (height * .92f));

            RenderSystem.m_69471_();
            graphics.m_85849_();
        }
    }
}
