/*
 * Decompiled with CFR 0.152.
 */
package tocraft.craftedcore.network.fabric;

import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2817;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import org.jetbrains.annotations.ApiStatus;
import tocraft.craftedcore.network.ModernNetworking;

public class ModernNetworkingImpl {
    public static void registerReceiver(ModernNetworking.Side side, class_2960 id, ModernNetworking.Receiver receiver) {
        if (side == ModernNetworking.Side.C2S) {
            PayloadTypeRegistry.playC2S().register(ModernNetworking.getType(id), ModernNetworking.PacketPayload.streamCodec());
            ServerPlayNetworking.registerGlobalReceiver(ModernNetworking.getType(id), (payload, context) -> receiver.receive(new ModernNetworking.Context(){

                @Override
                public class_1657 getPlayer() {
                    return context.player();
                }

                @Override
                public ModernNetworking.Env getEnv() {
                    return ModernNetworking.Env.SERVER;
                }

                @Override
                public void queue(Runnable runnable) {
                    context.player().field_13995.execute(runnable);
                }
            }, payload.nbt()));
        } else if (side == ModernNetworking.Side.S2C) {
            PayloadTypeRegistry.playS2C().register(ModernNetworking.getType(id), ModernNetworking.PacketPayload.streamCodec());
            ClientPlayNetworking.registerGlobalReceiver(ModernNetworking.getType(id), (payload, context) -> receiver.receive(new ModernNetworking.Context(){

                @Override
                public class_1657 getPlayer() {
                    return context.player();
                }

                @Override
                public ModernNetworking.Env getEnv() {
                    return ModernNetworking.Env.CLIENT;
                }

                @Override
                public void queue(Runnable runnable) {
                    context.client().execute(runnable);
                }
            }, payload.nbt()));
        }
    }

    public static void registerType(class_2960 id) {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
            ModernNetworking.getType(id);
            PayloadTypeRegistry.playS2C().register(ModernNetworking.getType(id), ModernNetworking.PacketPayload.streamCodec());
        }
    }

    @ApiStatus.Internal
    public static class_2596<?> toPacket(ModernNetworking.Side side, class_8710 payload) {
        if (side == ModernNetworking.Side.C2S) {
            return new class_2817(payload);
        }
        return new class_2658(payload);
    }
}

