/*
 * Decompiled with CFR 0.152.
 */
package tocraft.craftedcore.network;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_634;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import tocraft.craftedcore.network.fabric.ModernNetworkingImpl;

public class ModernNetworking {
    private static final Map<class_2960, class_8710.class_9154<PacketPayload>> TYPES = new HashMap<class_2960, class_8710.class_9154<PacketPayload>>();

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerReceiver(Side side, class_2960 id, Receiver receiver) {
        void var2_2;
        void var1_1;
        ModernNetworkingImpl.registerReceiver(side, (class_2960)var1_1, (Receiver)var2_2);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerType(class_2960 id) {
        ModernNetworkingImpl.registerType(id);
    }

    public static class_8710.class_9154<PacketPayload> getType(class_2960 id) {
        if (!TYPES.containsKey(id)) {
            TYPES.put(id, (class_8710.class_9154<PacketPayload>)new class_8710.class_9154(id));
        }
        return TYPES.get(id);
    }

    public static void sendToPlayer(class_3222 player, class_2960 packetId, class_2487 data) {
        player.field_13987.method_14364(ModernNetworking.toPacket(Side.S2C, new PacketPayload(packetId, data)));
    }

    public static void sendToPlayers(Iterable<class_3222> players, class_2960 packetId, class_2487 data) {
        for (class_3222 player : players) {
            ModernNetworking.sendToPlayer(player, packetId, data);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void sendToServer(class_2960 packetId, class_2487 data) {
        class_634 connection = class_310.method_1551().method_1562();
        if (connection != null) {
            connection.method_52787(ModernNetworking.toPacket(Side.C2S, new PacketPayload(packetId, data)));
        }
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ApiStatus.Internal
    @ExpectPlatform.Transformed
    public static class_2596<?> toPacket(Side side, class_8710 payload) {
        void var1_1;
        return ModernNetworkingImpl.toPacket(side, (class_8710)var1_1);
    }

    public static enum Side {
        S2C,
        C2S;

    }

    @ApiStatus.Internal
    public record PacketPayload(class_2960 id, class_2487 nbt) implements class_8710
    {
        public PacketPayload(class_9129 buf) {
            this(buf.method_10810(), buf.method_10798());
        }

        public void write(class_9129 buf) {
            buf.method_10812(this.id);
            buf.method_10794((class_2520)this.nbt);
        }

        @NotNull
        public class_8710.class_9154<? extends class_8710> method_56479() {
            return ModernNetworking.getType(this.id);
        }

        public static class_9139<class_9129, PacketPayload> streamCodec() {
            return new class_9139<class_9129, PacketPayload>(){

                @NotNull
                public PacketPayload decode(@NotNull class_9129 buf) {
                    return new PacketPayload(buf);
                }

                public void encode(@NotNull class_9129 buf, @NotNull PacketPayload payload) {
                    buf.method_10812(payload.id);
                    buf.method_10794((class_2520)payload.nbt);
                }
            };
        }
    }

    public static enum Env {
        CLIENT,
        SERVER;

    }

    public static interface Context {
        public class_1657 getPlayer();

        public Env getEnv();

        public void queue(Runnable var1);
    }

    @FunctionalInterface
    public static interface Receiver {
        public void receive(Context var1, class_2487 var2);
    }
}

