/*
 * Decompiled with CFR 0.152.
 */
package tocraft.craftedcore.data;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_7654;
import org.jetbrains.annotations.NotNull;
import tocraft.craftedcore.CraftedCore;
import tocraft.craftedcore.network.ModernNetworking;
import tocraft.craftedcore.patched.Identifier;

public abstract class SynchronizedJsonReloadListener
extends class_4080<Map<class_2960, JsonElement>> {
    public final class_2960 RELOAD_SYNC;
    protected final String directory;
    protected final Gson gson;
    private final Map<class_2960, JsonElement> map = new HashMap<class_2960, JsonElement>();

    public SynchronizedJsonReloadListener(Gson gson, String directory) {
        this.gson = gson;
        this.directory = directory;
        this.RELOAD_SYNC = CraftedCore.id("data_sync_" + directory);
    }

    @NotNull
    protected Map<class_2960, JsonElement> prepare(class_3300 resourceManager, class_3695 profilerFiller) {
        HashMap<class_2960, JsonElement> map = new HashMap<class_2960, JsonElement>();
        this.scanDirectory(resourceManager, map);
        return map;
    }

    protected void apply(Map<class_2960, JsonElement> map, class_3300 resourceManager, class_3695 profiler) {
        this.map.clear();
        this.map.putAll(map);
        this.onApply(map);
    }

    protected abstract void onApply(Map<class_2960, JsonElement> var1);

    public void sendSyncPacket(class_3222 player) {
        class_2487 compound = new class_2487();
        this.map.forEach((key, json) -> compound.method_10582(key.toString(), json.toString()));
        ModernNetworking.sendToPlayer(player, this.RELOAD_SYNC, compound);
    }

    @Environment(value=EnvType.CLIENT)
    private void onPacketReceive(ModernNetworking.Context context, class_2487 compound) {
        HashMap<class_2960, JsonElement> map = new HashMap<class_2960, JsonElement>();
        if (compound != null) {
            for (String key : compound.method_10541()) {
                this.map.put(Identifier.parse(key), JsonParser.parseString((String)compound.method_10558(key)));
            }
        }
        this.onApply(map);
    }

    @Environment(value=EnvType.CLIENT)
    public void registerPacketReceiver() {
        ModernNetworking.registerReceiver(ModernNetworking.Side.S2C, this.RELOAD_SYNC, this::onPacketReceive);
    }

    private void scanDirectory(class_3300 resourceManager, Map<class_2960, JsonElement> map) {
        class_7654 var4 = class_7654.method_45114((String)this.directory);
        Set entrySet = var4.method_45113(resourceManager).entrySet();
        for (Map.Entry entry : entrySet) {
            class_2960 var7 = (class_2960)entry.getKey();
            class_2960 var8 = var4.method_45115(var7);
            try (BufferedReader reader = ((class_3298)entry.getValue()).method_43039();){
                JsonElement var10 = (JsonElement)class_3518.method_15276((Gson)this.gson, (Reader)reader, JsonElement.class);
                JsonElement var11 = map.put(var8, var10);
                if (var11 == null) continue;
                throw new IllegalStateException("Duplicate data file ignored with ID " + String.valueOf(var8));
            }
            catch (JsonParseException | IOException | IllegalArgumentException var14) {
                LogUtils.getLogger().error("Couldn't parse data file {} from {}", new Object[]{var8, var7, var14});
            }
        }
    }
}

