/*
 * Decompiled with CFR 0.152.
 */
package tocraft.craftedcore.config;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import tocraft.craftedcore.CraftedCore;
import tocraft.craftedcore.config.Config;
import tocraft.craftedcore.config.annotions.Comment;
import tocraft.craftedcore.patched.TComponent;

@ApiStatus.Internal
@Environment(value=EnvType.CLIENT)
public class ClothConfigApi {
    @Nullable
    public static class_437 constructConfigScreen(Config config, class_437 parent) {
        try {
            Config defaultC = (Config)config.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((class_2561)TComponent.literal(String.format("Config Screen for %s", config.getName()))).setSavingRunnable(config::save);
            ConfigCategory general = builder.getOrCreateCategory((class_2561)TComponent.literal("General"));
            for (Field field : config.getClass().getDeclaredFields()) {
                String name = field.getName();
                ConfigEntryBuilder entryBuilder = builder.entryBuilder();
                try {
                    String tooltip = "";
                    for (Annotation annotation : field.getDeclaredAnnotations()) {
                        if (!(annotation instanceof Comment)) continue;
                        Comment comment = (Comment)annotation;
                        tooltip = comment.value();
                        break;
                    }
                    CraftedCore.LOGGER.warn("Class of field {} is {}", (Object)name, field.getType());
                    if (Boolean.TYPE.isAssignableFrom(field.getType()) || Boolean.class.isAssignableFrom(field.getType())) {
                        general.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)TComponent.literal(name), field.getBoolean(config)).setTooltip(new class_2561[]{TComponent.literal(tooltip)}).setDefaultValue(field.getBoolean(defaultC)).setSaveConsumer(n -> {
                            try {
                                field.setBoolean(config, (boolean)n);
                            }
                            catch (IllegalAccessException e) {
                                CraftedCore.LOGGER.error("Couldn't save config field {}", (Object)name);
                            }
                        }).build());
                        CraftedCore.LOGGER.warn("registered boolean " + name + " info; " + tooltip);
                        continue;
                    }
                    if (Integer.TYPE.isAssignableFrom(field.getType()) || Integer.class.isAssignableFrom(field.getType())) {
                        general.addEntry((AbstractConfigListEntry)entryBuilder.startIntField((class_2561)TComponent.literal(name), field.getInt(config)).setTooltip(new class_2561[]{TComponent.literal(tooltip)}).setDefaultValue(field.getInt(defaultC)).setSaveConsumer(n -> {
                            try {
                                field.setInt(config, (int)n);
                            }
                            catch (IllegalAccessException e) {
                                CraftedCore.LOGGER.error("Couldn't save config field {}", (Object)name);
                            }
                        }).build());
                        continue;
                    }
                    if (Float.TYPE.isAssignableFrom(field.getType()) || Float.class.isAssignableFrom(field.getType())) {
                        general.addEntry((AbstractConfigListEntry)entryBuilder.startFloatField((class_2561)TComponent.literal(name), field.getFloat(config)).setTooltip(new class_2561[]{TComponent.literal(tooltip)}).setDefaultValue(field.getFloat(defaultC)).setSaveConsumer(n -> {
                            try {
                                field.setFloat(config, n.floatValue());
                            }
                            catch (IllegalAccessException e) {
                                CraftedCore.LOGGER.error("Couldn't save config field {}", (Object)name);
                            }
                        }).build());
                        continue;
                    }
                    if (Double.TYPE.isAssignableFrom(field.getType()) || Double.class.isAssignableFrom(field.getType())) {
                        general.addEntry((AbstractConfigListEntry)entryBuilder.startDoubleField((class_2561)TComponent.literal(name), field.getDouble(config)).setTooltip(new class_2561[]{TComponent.literal(tooltip)}).setDefaultValue(field.getDouble(defaultC)).setSaveConsumer(n -> {
                            try {
                                field.setDouble(config, (double)n);
                            }
                            catch (IllegalAccessException e) {
                                CraftedCore.LOGGER.error("Couldn't save config field {}", (Object)name);
                            }
                        }).build());
                        continue;
                    }
                    if (Long.TYPE.isAssignableFrom(field.getType()) || Long.class.isAssignableFrom(field.getType())) {
                        general.addEntry((AbstractConfigListEntry)entryBuilder.startLongField((class_2561)TComponent.literal(name), field.getLong(config)).setTooltip(new class_2561[]{TComponent.literal(tooltip)}).setDefaultValue(field.getLong(defaultC)).setSaveConsumer(n -> {
                            try {
                                field.setLong(config, (long)n);
                            }
                            catch (IllegalAccessException e) {
                                CraftedCore.LOGGER.error("Couldn't save config field {}", (Object)name);
                            }
                        }).build());
                        continue;
                    }
                    if (!String.class.isAssignableFrom(field.getType())) continue;
                    general.addEntry((AbstractConfigListEntry)entryBuilder.startStrField((class_2561)TComponent.literal(name), (String)field.get(config)).setTooltip(new class_2561[]{TComponent.literal(tooltip)}).setDefaultValue((String)field.get(defaultC)).setSaveConsumer(n -> {
                        try {
                            field.set(config, n);
                        }
                        catch (IllegalAccessException e) {
                            CraftedCore.LOGGER.error("Couldn't save config field {}", (Object)name);
                        }
                    }).build());
                }
                catch (IllegalAccessException e) {
                    CraftedCore.LOGGER.error("Couldn't create config entry {} for config {}. Caught: {}", new Object[]{name, config.getName(), e});
                }
            }
            return builder.build();
        }
        catch (Exception e) {
            CraftedCore.LOGGER.error("Couldn't create config file {}", (Object)config.getName());
            return null;
        }
    }
}

