package tocraft.craftedcore.mixin.client;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2535;
import net.minecraft.class_2678;
import net.minecraft.class_2724;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_746;
import net.minecraft.class_8673;
import net.minecraft.class_8675;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tocraft.craftedcore.event.client.ClientPlayerEvents;

@SuppressWarnings("unused")
@Environment(EnvType.CLIENT)
@Mixin(class_634.class)
//#if MC>1201
public abstract class ClientPacketListenerMixin extends class_8673 {
    protected ClientPacketListenerMixin(class_310 minecraft, class_2535 connection, class_8675 commonListenerCookie) {
        super(minecraft, connection, commonListenerCookie);
    }
//#else
//$$ public abstract class ClientPacketListenerMixin {
//#endif

    @Unique
    private class_746 craftedcore$oldPlayer = null;

    //#if MC<=1201
    //$$ @Shadow
    //$$ @Final
    //$$ private Minecraft minecraft;
    //#endif

    @Inject(method = "handleLogin", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/Options;setServerRenderDistance(I)V", shift = At.Shift.AFTER))
    private void handleLogin(class_2678 packet, CallbackInfo ci) {
        ClientPlayerEvents.CLIENT_PLAYER_JOIN.invoke().join(field_45588.field_1724);
    }

    @Inject(method = "handleRespawn", at = @At("HEAD"))
    private void handleRespawnPre(class_2724 packet, CallbackInfo ci) {
        this.craftedcore$oldPlayer = field_45588.field_1724;
    }

    @Inject(method = "handleRespawn", at = @At(value = "INVOKE",
            //#if MC>1201
            target = "Lnet/minecraft/client/multiplayer/ClientLevel;addEntity(Lnet/minecraft/world/entity/Entity;)V"))
            //#else
            //$$ target = "Lnet/minecraft/client/multiplayer/ClientLevel;addPlayer(ILnet/minecraft/client/player/AbstractClientPlayer;)V"))
    //#endif
    private void handleRespawn(class_2724 packet, CallbackInfo ci) {
        ClientPlayerEvents.CLIENT_PLAYER_RESPAWN.invoke().respawn(this.craftedcore$oldPlayer, field_45588.field_1724);
        this.craftedcore$oldPlayer = null;
    }
}
