package tocraft.craftedcore.data;

import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.nbt.*;
import tocraft.craftedcore.CraftedCore;
import tocraft.craftedcore.network.ModernNetworking;
import tocraft.craftedcore.network.client.ClientNetworking;
import tocraft.craftedcore.patched.CEntity;
import tocraft.craftedcore.registration.PlayerDataRegistry;

import java.util.Objects;

public class PlayerDataSynchronizer {
    private static final String PLAYER_DATA_SYNC = "player_data_sync";
    public static final class_2960 PLAYER_DATA_SYNC_ID = CraftedCore.id(PLAYER_DATA_SYNC);

    public static void registerPacketHandler() {
        ModernNetworking.registerReceiver(ModernNetworking.Side.S2C, PLAYER_DATA_SYNC_ID, (context, tag) -> {
            if (tag != null) {
                class_2499 list = (class_2499) tag.method_10580(PLAYER_DATA_SYNC);
                if (list != null) {
                    for (class_2520 entry : list) {
                            for (String key : ((class_2487) entry).method_10541()) {
                                if (Objects.equals(key, "DELETED")) {
                                    ClientNetworking.runOrQueue(context, player -> {
                                        PlayerDataProvider playerDataProvider;
                                        if (tag.method_25928("uuid")) {
                                            playerDataProvider = (PlayerDataProvider) player.method_5770().method_18470(tag.method_25926("uuid"));
                                        } else {
                                            playerDataProvider = (PlayerDataProvider) player;
                                        }
                                        if (playerDataProvider != null) {
                                            playerDataProvider.craftedcore$writeTag(Objects.requireNonNull(((class_2487) entry).method_10580(key)).method_10714(), null);
                                        }
                                    });
                                } else {
                                    ClientNetworking.runOrQueue(context, player -> {
                                        PlayerDataProvider playerDataProvider;
                                        if (tag.method_25928("uuid")) {
                                            playerDataProvider = (PlayerDataProvider) player.method_5770().method_18470(tag.method_25926("uuid"));
                                        } else {
                                            playerDataProvider = (PlayerDataProvider) player;
                                        }
                                        if (playerDataProvider != null) {
                                            playerDataProvider.craftedcore$writeTag(key, ((class_2487) entry).method_10580(key));
                                        }
                                    });
                                }
                            }
                    }
                }
            }
        });
    }

    /**
     * Synchronize data from the server to the client
     */
    public static void sync(class_3222 player) {
        syncToSelf(player);
        syncToAll(player);
    }

    private static void syncToSelf(class_3222 player) {
        class_2487 tag = new class_2487();
        class_2499 list = new class_2499();

        PlayerDataProvider playerData = ((PlayerDataProvider) player);

        for (String key : ((PlayerDataProvider) player).craftedcore$keySet()) {
            // ignore key if it shouldn't be synchronized to the client
            if (!PlayerDataRegistry.shouldSyncTagToSelf(key)) {
                return;
            }

            class_2487 entry = new class_2487();
            class_2520 value = playerData.craftedcore$readTag(key);
            if (value != null) {
                entry.method_10566(key, value);
            } else {
                entry.method_10566("DELETED", class_2519.method_23256(key));
            }            list.add(entry);
        }
        tag.method_10566(PLAYER_DATA_SYNC, list);

        ModernNetworking.sendToPlayer(player, PLAYER_DATA_SYNC_ID, tag);
    }

    private static void syncToAll(class_3222 player) {
        class_2487 tag = new class_2487();
        class_2499 list = new class_2499();

        tag.method_25927("uuid", player.method_5667());
        PlayerDataProvider playerData = ((PlayerDataProvider) player);

        for (String key : ((PlayerDataProvider) player).craftedcore$keySet()) {
            // ignore key if it shouldn't be synchronized to the client
            if (!PlayerDataRegistry.shouldSyncTagToAll(key)) {
                return;
            }

            class_2487 entry = new class_2487();
            class_2520 value = playerData.craftedcore$readTag(key);
            if (value != null) {
                entry.method_10566(key, value);
            } else {
                entry.method_10566("DELETED", class_2519.method_23256(key));
            }
            list.add(entry);
        }
        tag.method_10566(PLAYER_DATA_SYNC, list);
        //noinspection resource
        ModernNetworking.sendToPlayers(((class_3218) CEntity.level(player)).method_18456(), PLAYER_DATA_SYNC_ID, tag);
    }
}
