package tocraft.craftedcore.network;

import dev.architectury.networking.NetworkManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import org.jetbrains.annotations.NotNull;

import java.util.HashMap;
import java.util.Map;

@SuppressWarnings("unused")
public final class ModernNetworking {
    private static final Map<class_2960, class_8710.class_9154<PacketPayload>> TYPES = new HashMap<>();

    public static void registerReceiver(Side side, class_2960 id, Receiver receiver) {
        TYPES.put(id, new class_8710.class_9154<>(id));
        NetworkManager.registerReceiver(side == Side.C2S ? NetworkManager.Side.C2S : NetworkManager.Side.S2C, TYPES.get(id), class_8710.method_56484(PacketPayload::write, PacketPayload::new), (packet, context) -> receiver.receive(new Context() {
            @Override
            public class_1657 getPlayer() {
                return context.getPlayer();
            }

            @Override
            public EnvType getEnv() {
                return context.getEnv();
            }

            @Override
            public void queue(Runnable runnable) {
                context.queue(runnable);
            }
        }, packet.nbt()));
    }

    public static void sendToPlayer(class_3222 player, class_2960 packetId, class_2487 data) {
        NetworkManager.sendToPlayer(player, new PacketPayload(packetId, data));
    }

    public static void sendToPlayers(Iterable<class_3222> players, class_2960 packetId, class_2487 data) {
        for (class_3222 player : players) {
            NetworkManager.sendToPlayer(player, new PacketPayload(packetId, data));
        }
    }

    @Environment(EnvType.CLIENT)
    public static void sendToServer(class_2960 packetId, class_2487 data) {
        NetworkManager.sendToServer(new PacketPayload(packetId, data));
    }

    @FunctionalInterface
    public interface Receiver {
        void receive(Context context, class_2487 data);
    }

    public interface Context {
        class_1657 getPlayer();

        EnvType getEnv();

        void queue(Runnable runnable);
    }

    public enum Side {
        S2C, C2S
    }

    private record PacketPayload(class_2960 id,
                                 class_2487 nbt) implements class_8710 {

        public PacketPayload(class_9129 buf) {
            this(buf.method_10810(), buf.method_10798());
        }

        public void write(class_9129 buf) {
            buf.method_10812(id());
            buf.method_10794(nbt);
        }

        @Override
        public @NotNull class_9154<? extends class_8710> method_56479() {
            return TYPES.get(id());
        }
    }
}
