package tocraft.craftedcore.mixin.client;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2535;
import net.minecraft.class_2678;
import net.minecraft.class_2724;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_746;
import net.minecraft.class_8673;
import net.minecraft.class_8675;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tocraft.craftedcore.event.client.ClientPlayerEvents;

@Environment(EnvType.CLIENT)
@Mixin(class_634.class)
public abstract class ClientPacketListenerMixin extends class_8673 {
    @Unique
    private class_746 craftedcore$oldPlayer = null;

    protected ClientPacketListenerMixin(class_310 minecraft, class_2535 connection, class_8675 commonListenerCookie) {
        super(minecraft, connection, commonListenerCookie);
    }

    @Inject(method = "handleLogin", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/Options;setServerRenderDistance(I)V", shift = At.Shift.AFTER))
    private void handleLogin(class_2678 packet, CallbackInfo ci) {
        ClientPlayerEvents.CLIENT_PLAYER_JOIN.invoke().join(field_45588.field_1724);
    }

    @Inject(method = "handleRespawn", at = @At("HEAD"))
    private void handleRespawnPre(class_2724 packet, CallbackInfo ci) {
        this.craftedcore$oldPlayer = field_45588.field_1724;
    }

    @Inject(method = "handleRespawn", at = @At(value = "INVOKE",
            target = "Lnet/minecraft/client/multiplayer/ClientLevel;addEntity(Lnet/minecraft/world/entity/Entity;)V"))
    private void handleRespawn(class_2724 packet, CallbackInfo ci) {
        ClientPlayerEvents.CLIENT_PLAYER_RESPAWN.invoke().respawn(this.craftedcore$oldPlayer, field_45588.field_1724);
        this.craftedcore$oldPlayer = null;
    }
}
