package tocraft.craftedcore.mixin;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tocraft.craftedcore.data.PlayerDataProvider;
import tocraft.craftedcore.registration.PlayerDataRegistry;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

@Mixin(class_1657.class)
public abstract class PlayerMixin implements PlayerDataProvider {
    @Unique
    private final Map<String, class_2520> craftedcore$playerData = new HashMap<String, class_2520>();

    @Inject(method = "readAdditionalSaveData", at = @At("RETURN"))
    private void readNbt(class_2487 tag, CallbackInfo info) {
        for (String key : PlayerDataRegistry.keySet()) {
            craftedcore$playerData.put(key, tag.method_10580(key));
        }
    }

    @Inject(method = "addAdditionalSaveData", at = @At("RETURN"))
    private void writeNbt(class_2487 tag, CallbackInfo info) {
        craftedcore$playerData.forEach((key, value) -> tag.method_10566(key, this.craftedcore$readTag(key)));
    }

    @Unique
    @Override
    public Set<String> craftedcore$keySet() {
        return craftedcore$playerData.keySet();
    }

    @Unique
    @Override
    public void craftedcore$writeTag(String key, class_2520 tag) {
        if (!PlayerDataRegistry.keySet().contains(key))
            PlayerDataRegistry.registerKey(key, false);

        craftedcore$playerData.put(key, tag);
    }

    @Unique
    @Override
    public class_2520 craftedcore$readTag(String key) {
        return craftedcore$playerData.get(key);
    }
}
